<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">{{__('lang.admin_push_noti_list')}}</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th>{{__('lang.admin_image')}}</th>
                               <th>{{__('lang.admin_title')}}</th>
                               <th>{{__('lang.admin_description')}}</th>
                               <th>{{__('lang.admin_date')}}</th>
                                @can('delete-notifications')
                               <th>{{__('lang.admin_table_action')}}</th>
                               @endcan
                           </tr>
                       </thead>
                       <tbody>
                           @if(count($data) > 0)
                           @foreach($data as $res)
                           <tr>
                                <td aria-colindex="2" role="cell" class="">
                                    <span class="b-avatar mr-1 badge-secondary rounded-circle">
                                        <span class="b-avatar-img">
                                            @if($res->image!='')
                                                <img src="{{asset('/app-assets/images/notification/'.$res->image)}}" width="100px" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';">
                                            @else
                                                <img src="{{asset('/app-assets/images/no-image.png')}}">
                                            @endif
                                        </span>
                                    </span>
                                </td>
                                <td>{{ isset($res->title)?$res->title:'--' }}</td>
                                <td>{{ isset($res->description)?$res->description:'--' }}</td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                                @can('delete-notifications')
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('notification' , {{ $res->id }})">
                                                <i data-feather="trash" class="me-50"></i>
                                                <span>{{__('lang.admin_button_delete')}}</span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                                @endcan
                           </tr>
                           @endforeach
                           @else
                           <tr>
                               <td colspan="5" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                           </tr>
                           @endif
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
