@can('dashboard')
<li class="{{ (Request::is('admin/dashboard*') || Request::segment('2')=='') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('dashboard')!!}"><i data-feather="home"></i><span class="menu-title text-truncate" data-i18n="Dashboards">{{__('lang.admin_menu_dashboard')}}</span></a>
</li>
@endcan

<!-- Lists -->
@can('products')
<li class="{{ Request::is('admin/product*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('products.index') !!}"><i data-feather="box"></i><span class="menu-title text-truncate" data-i18n="Products">{{__('lang.admin_menu_products')}}</span></a>
</li>
@endcan



<!-- Orders -->
@canany(['orders', 'cancel-order-request','delivery','revenue','subscription'])
<li class=" nav-item has-sub {{ Request::is('admin/orders*') || Request::is('admin/delivery') || Request::is('admin/revenue*') ? 'open':'' }}"
>
    <a class="d-flex align-items-center" href="#"><i data-feather="shopping-bag"></i><span class="menu-title text-truncate" data-i18n="Orders">{{__('lang.admin_menu_orders')}}</span><span class="badge badge-light-warning rounded-pill ms-auto me-1">5</span></a>
    <ul class="menu-content">
        @can('orders')
        <li class="{{ Request::is('admin/orders*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/orders') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_orders_list')}}</span></a>
        </li>
        @endcan
        @can('cancel-order-request')
        <li class="{{ Request::is('admin/cancel-order-request*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/cancel-order-request') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="Cancel Order Request">{{__('lang.admin_menu_cancel_request')}}</span><!-- <span class="badge badge-light-warning rounded-pill ms-auto me-1">1</span> --></a>
        </li>
        @endcan
        @can('delivery')
        <li class="{{ Request::is('admin/delivery') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/delivery') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_day_delivery')}}</span></a>
        </li>
        @endcan
        @can('revenue')
        <li class="{{ Request::is('admin/revenue*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/revenue') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_revenue')}}</span></a>
        </li>
        @endcan
        @can('subscription')
        <li class="{{ Request::is('admin/subscription*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/subscription') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_active_subscription')}}</span></a>
        </li>
        @endcan
    </ul>
</li>
@endcanany

<!-- Payment -->
@can('payments')
<li class="{{ Request::is('admin/payments*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('payments.index') !!}"><i data-feather="credit-card"></i><span class="menu-title text-truncate" data-i18n="Payments">{{__('lang.admin_menu_payments')}}</span></a>
</li>
@endcan

@can('coupons')
<li class="{{ Request::is('admin/coupons*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('coupons.index') !!}"><i data-feather="tag"></i><span class="menu-title text-truncate" data-i18n="Coupons">{{__('lang.admin_menu_offers')}}</span></a>
</li>
@endcan

@canany(['users','drivers','sub-admin','role',''])
<!-- Management -->
<li class="navigation-header"><span data-i18n="Apps &amp; Pages">{{__('lang.admin_management')}}</span><i data-feather="more-horizontal"></i></li>

@can('users')
<li class="{{ Request::is('admin/users*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('users.index') !!}"><i data-feather="user"></i><span class="menu-title text-truncate" data-i18n="Users">{{__('lang.admin_menu_users')}}</span></a>
</li>
@endcan

@can('drivers')
<li class="{{ Request::is('admin/drivers*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('drivers.index') !!}"><i data-feather="truck"></i><span class="menu-title text-truncate" data-i18n="Drivers">{{__('lang.admin_menu_drivers')}}</span></a>
</li>
@endcan

@can('sub-admin')
<li class="{{ Request::is('admin/sub-admin*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{{url('admin/sub-admin')}}"><i data-feather="user"></i><span class="menu-title text-truncate" data-i18n="Contacts">{{__('lang.admin_subadmins')}}</span></a>
</li>
@endcan

@can('role')
<li class="{{ Request::is('admin/role*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{{url('admin/role')}}"><i data-feather="shield"></i><span class="menu-title text-truncate" data-i18n="Contacts">{{__('lang.admin_role_has_permission')}}</span></a>
</li>
@endcan

@endcanany


<!-- Delivery Areas -->
@can('delivery_areas')
<li class="navigation-header"><span data-i18n="User Interface">{{__('lang.admin_menu_delivery_areas')}}</span><i data-feather="more-horizontal"></i></li>
<li class=" nav-item has-sub {{ Request::is('admin/settings/app/*') ? 'open':'' }}"
>
    <a class="d-flex align-items-center" href="#"><i data-feather="settings"></i><span class="menu-title text-truncate" data-i18n="Settings">{{__('lang.admin_menu_delivery_areas')}}</span><span class="badge badge-light-warning rounded-pill ms-auto me-1">3</span></a>
    <ul class="menu-content">
        <li class="{{ Request::is('admin/delivery_areas') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/delivery_areas') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_delivery_areas')}} </span></a>
        </li>
        <li class="{{ Request::is('admin/city') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/city') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_city')}} </span></a>
        </li>
        <li class="{{ Request::is('admin/state') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/state') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_state')}} </span></a>
        </li>
    </ul>
</li>
@endcan


<!-- Settings -->
@canany(['all-settings','holidays','timeslots','currencies'])
<li class="navigation-header"><span data-i18n="User Interface">{{__('lang.admin_menu_settings')}}</span><i data-feather="more-horizontal"></i></li>
<li class=" nav-item has-sub {{ Request::is('admin/settings/app/*') ? 'open':'' }}"
>
    <a class="d-flex align-items-center" href="#"><i data-feather="settings"></i><span class="menu-title text-truncate" data-i18n="Settings">{{__('lang.admin_menu_settings')}}</span><span class="badge badge-light-warning rounded-pill ms-auto me-1">12</span></a>
    <ul class="menu-content">
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/globals*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/globals') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_global_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/apps*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/apps') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_app_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/orders*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/orders') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_order_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/notifications*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/notifications') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_notification_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/websetting*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/websetting') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_website_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/homepagesetting*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/homepagesetting') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_home_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/emailsetting*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/emailsetting') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_email_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/smssetting*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/smssetting') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_msg_settings')}}</span></a>
        </li>
        @endcan
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/deeplinksetting*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/deeplinksetting') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_deeplink_settings')}}</span></a>
        </li>
        @endcan
        
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/social*') ? 'active' : '' }} nav-item">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/social') !!}"><i data-feather="circle"></i><span class="menu-title text-truncate" data-i18n="Social">{{__('lang.admin_menu_social')}}</span></a>
        </li>
        @endcan
        
        @can('all-settings')
        <li class="{{ Request::is('admin/settings/app/payment*') ? 'active' : '' }} nav-item">
            <a class="d-flex align-items-center" href="{!! url('admin/settings/app/payment') !!}"><i data-feather="circle"></i><span class="menu-title text-truncate" data-i18n="Payment Gateway">{{__('lang.admin_menu_payment_gateway')}}</span></a>
        </li>
        @endcan
       
        @can('holidays')
        <li class="{{ Request::is('admin/holidays*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/holidays') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_holidays')}} </span></a>
        </li>
        @endcan

        @can('timeslots')
        <li class="{{ Request::is('admin/timeslots*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/timeslots') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_timeslots')}}</span></a>
        </li>
        @endcan

        @can('currencies')
        <li class="{{ Request::is('admin/currencies*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/currencies') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_currency')}}</span></a>
        </li>
        @endcan
    </ul>
</li>
@endcanany

@canany(['banners','coupons','site_contents','contact_us','about_us'])
<!-- Apps and Pages -->
<li class="navigation-header"><span data-i18n="Apps &amp; Pages">{{__('lang.admin_menu_apps')}} &amp; {{__('lang.admin_menu_pages')}}</span><i data-feather="more-horizontal"></i></li>

@can('banners')
<li class="{{ Request::is('admin/banners*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('banners.index') !!}"><i data-feather="image"></i><span class="menu-title text-truncate" data-i18n="Banners">{{__('lang.admin_menu_banners')}}</span></a>
</li>
@endcan



@can('site_contents')
<li class="{{ Request::is('admin/site_contents*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('site_contents.index') !!}"><i data-feather="layers"></i><span class="menu-title text-truncate" data-i18n="CMS">{{__('lang.admin_menu_cms')}}</span></a>
</li>
@endcan

@can('contact_us')
<li class="{{ Request::is('admin/contact_us*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('contact_us.index') !!}"><i data-feather="message-circle"></i><span class="menu-title text-truncate" data-i18n="Contacts">{{__('lang.admin_menu_contact_us')}}</span></a>
</li>
@endcan

@can('about_us')
<li class="{{ Request::is('admin/about_us*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! route('about_us.index') !!}"><i data-feather="info"></i><span class="menu-title text-truncate" data-i18n="Contacts">{{__('lang.admin_menu_partners')}}</span></a>
</li>
@endcan

@endcanany

@canany(['languages','keywords'])
<!-- Apps and Pages -->
<li class="navigation-header"><span data-i18n="Apps &amp; Pages">{{__('lang.admin_menu_localization')}} &amp; {{__('lang.admin_menu_pages')}}</span><i data-feather="more-horizontal"></i></li>

<li class=" nav-item has-sub {{ Request::is('admin/languages*') || Request::is('admin/keywords*') ? 'open':'' }}"
>
    <a class="d-flex align-items-center" href="#"><i data-feather="type"></i><span class="menu-title text-truncate" data-i18n="Localisation">{{__('lang.admin_menu_localisation')}}</span><span class="badge badge-light-warning rounded-pill ms-auto me-1">2</span></a>
    <ul class="menu-content">
        @can('languages')
        <li class="{{ Request::is('admin/languages*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/languages') !!}"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_language_list')}}</span></a>
        </li>
        @endcan
        @can('keywords')
        <li class="{{ Request::is('admin/keywords*') ? 'active' : '' }}">
            <a class="d-flex align-items-center" href="{!! url('admin/keywords') !!}?lang_code=en"><i data-feather="circle"></i><span class="menu-item text-truncate" data-i18n="eCommerce">{{__('lang.admin_menu_language_keyword')}}</span></a>
        </li>
        @endcan
    </ul>
</li>
@endcanany

@can('notifications')
<li class="{{ Request::is('admin/notifications*') ? 'active' : '' }} nav-item">
    <a class="d-flex align-items-center" href="{!! url('admin/notifications') !!}"><i data-feather="bell"></i><span class="menu-title text-truncate" data-i18n="Push Notification">{{__('lang.admin_menu_push_notification')}}</span></a>
</li>
@endcan

