<!DOCTYPE html>
<html class="loading hide bordered-layout" lang="en" data-layout="bordered-layout" data-textdirection="ltr"><!-- dark-layout -->
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="description" content="Mobile APP">
    <meta name="keywords" content="Mobile APP">
    <meta name="author" content="Team June">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="project-url" content="{{ url('/') }}">
    <title>{{setting('site_title')}}</title>
    @if(setting('website_favicon')!='')
    <link rel="icon" type="image/x-icon" href="{{url('site-assets/images/website/'.setting('website_favicon'))}}" />
    @else
    <link rel="icon" type="image/x-icon" href="{{url('uploads/no-favicon.ico')}}" />
    @endif
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600" rel="stylesheet">

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/vendors.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/extensions/toastr.min.css')}}">
    <!-- Datatable css -->
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap5.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/rowGroup.bootstrap4.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}">
    <!-- Select2 CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('site-assets/css/select2.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    @php
        $direct = "";
        if (Session()->get('admin_direction') != '') {
            if (Session()->get('admin_direction') == 'rtl') {
                $direct = "-rtl";
            }
        }
    @endphp
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css' . $direct . '/bootstrap.css') }}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/bootstrap-extended.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/colors.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/components.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/themes/dark-layout.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/themes/bordered-layout.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/themes/semi-dark-layout.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/core/menu/menu-types/vertical-menu.css')}}">
    <script src="https://maps.googleapis.com/maps/api/js?key={{ setting('google_address_map_api_key') }}&libraries=places"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/plugins/extensions/ext-component-toastr.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css' . $direct . '/plugins/forms/pickers/form-flat-pickr.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/css/style' . $direct . '.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css/app-todo.css')}}">
    <link rel="stylesheet" type="text/css" href="{{ asset('site-assets/css/custom.css') }}">
    <script>
        var base_url = '{{url("")}}';
        var nearest_delivery_date = {{ setting("nearest_delivery_date") ?? 1 }};
    </script>
    <style type="text/css">
        .pac-container{
                z-index: 10010;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern  navbar-floating footer-static  " data-open="click" data-menu="vertical-menu-modern" data-col="">
    <nav class="header-navbar navbar navbar-expand-lg align-items-center floating-nav navbar-light navbar-shadow container-xxl">
        <div class="navbar-container d-flex content">
            <div class="bookmark-wrapper d-flex align-items-center">
                <ul class="nav navbar-nav d-xl-none">
                    <li class="nav-item"><a class="nav-link menu-toggle" href="#"><i class="ficon" data-feather="menu"></i></a></li>
                </ul>
            </div>
            <ul class="nav navbar-nav align-items-center ms-auto">
                <li class="nav-item dropdown dropdown-language">
                    <?php
                    $langList = \Helpers::getAllLangList();

                    if (Session()->has('admin_locale') AND array_key_exists(Session()->get('admin_locale'), config('languages'))) {
                        $langCode = Session()->get('admin_locale');
                    }
                    else { // This is optional as Laravel will automatically set the fallback language if there is none specified
                        $langCode = config('app.fallback_locale');
                    }
                    ?>
                    <a class="nav-link dropdown-toggle" id="dropdown-flag" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fas fa-language rounded-circle ti-md" aria-hidden="true"></i>
                       <span class="selected-language">{{config('languages')[$langCode]}}</span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-flag">
                        @if(count($langList)>0)
                            @foreach($langList as $langRow)
                                <a class="dropdown-item" href="{!! url('/admin/setlang') !!}?lang={{$langRow->language_code}}" data-language="{{$langRow->language_code}}">
                                    <i class="fas fa-language rounded-circle ti-md" aria-hidden="true"></i>
                                 {{$langRow->language_name}}
                             </a>
                            @endforeach
                        @endif
                    </div>
                </li>
                <li class="nav-item d-none d-lg-block">
                    <a class="nav-link nav-link-style">
                        <i class="ficon" data-feather="sun" id="dark"></i>
                        <i class="ficon" data-feather="moon" id="light"></i>
                    </a>
                </li>
                <li class="nav-item dropdown dropdown-user">
                    @auth
                    <a class="nav-link dropdown-toggle dropdown-user-link" id="dropdown-user" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="user-nav d-sm-flex d-none"><span class="user-name fw-bolder">{!! auth()->user()->name !!}</span><span class="user-status">{{auth()->user()->type}}</span></div><span class="avatar">
                            @if(auth()->user()->image)
                            <img class="round" src="{{asset('app-assets/images/users/'.auth()->user()->image)}}" alt="avatar" height="40" width="40" onerror="this.onerror=null;this.src=`{{ asset('site-assets/images/User.svg') }}`"><span class="avatar-status-online">
                            @else
                            <img class="round" src="{{asset('app-assets/images/avatars/2.png')}}" alt="avatar" height="40" width="40" onerror="this.onerror=null;this.src=`{{ asset('site-assets/images/User.svg') }}`"><span class="avatar-status-online">
                            @endif
                                </span></span>
                    </a>
                    @endauth
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-user">
                        <a class="dropdown-item" href="{!! route('users.profile') !!}">
                            <i class="me-50" data-feather="user"></i> {{__('lang.admin_profile')}}
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="{!! url('/logout') !!}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><i class="me-50" data-feather="power"></i> {{__('lang.admin_logout')}}</a>
                        <form id="logout-form" action="{{ url('/logout') }}" method="POST" class="form-horizontal" style="display: none;">{{ csrf_field() }}</form>
                    </div>
                </li>
            </ul>
        </div>
    </nav>
    <div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
        <div class="navbar-header">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item me-auto">
                    <a class="navbar-brand" href="{!! route('dashboard')!!}">
                        <h2>
                            <img src="{{url('site-assets/images/website/'.setting('website_logo'))}}" onerror="this.onerror=null;this.src=`{{ asset('uploads/no-logo.png') }}`" style="width: 180px;height: 50px;margin-top: -20px;object-fit: scale-down;">
                        </h2>
                    </a>
                </li>
                <li class="nav-item nav-toggle"><a class="nav-link modern-nav-toggle pe-0" data-bs-toggle="collapse"><i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i><i class="d-none d-xl-block collapse-toggle-icon font-medium-4  text-primary" data-feather="disc" data-ticon="disc"></i></a></li>
            </ul>
        </div>
        <div class="shadow-bottom"></div>
        <div class="main-menu-content">
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                @include('layouts.menu')
            </ul>
        </div>
    </div>
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    @yield('content')
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light">
        <p class="clearfix mb-0"><span class="float-md-start d-block d-md-inline-block mt-25">{{__('lang.admin_footer_copyright')}} &copy; <?php echo date("Y");?>, {{__('lang.admin_footer_text')}}</span></span></p>
    </footer>
    <button class="btn btn-primary btn-icon scroll-top" type="button"><i data-feather="arrow-up"></i></button>

    {{-- enable firebase for admin --}}
    <input type="hidden" name="_token" id="csrf_token_page" value="{{ csrf_token() }}">
    <script type="module" src="{{ url('/firebase.js') }}"></script>
    {{-- end firebase for admin --}}
    <!-- END: Footer-->
    @if(Session::has('message'))
    <script>
        setTimeout(function () {
            toastr['success']('You have successfully logged in. Now you can start to explore!','👋 Welcome Admin!',{
                closeButton: true,
                tapToDismiss: false,
                rtl: isRtl
            });
        }, 2000);
    </script>
    @endif

    <!-- BEGIN: Vendor JS-->
    <script src="{{asset('app-assets/vendors/js/vendors.min.js')}}"></script>
    <!-- BEGIN Vendor JS-->


    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}"></script>
    <script src="{{asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js')}}"></script>

    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{asset('app-assets/js/core/app-menu.js')}}"></script>
    <script src="{{asset('app-assets/js/core/app.js')}}"></script>
    <!-- END: Theme JS-->

    <!-- BEGIN: Page JS-->
    <script src="{{asset('app-assets/js/scripts/components/components-tooltips.js')}}"></script>
    <script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
    <script src="{{asset('app-assets/js/scripts/pages/app-user-edit.js')}}"></script>
    <script src="{{asset('assets/js/scripts.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script src="{{asset('app-assets/js/scripts/forms/pickers/form-pickers.js')}}"></script>
    <!-- END: Page JS-->
    <script src="{{asset('site-assets/js/select2.js')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>

    <script>
        $(window).on('load', function() {
            function disablePrev() { window.history.forward() }
            disablePrev();
            window.onpageshow = function(evt) { if (evt.persisted) disableBack() }
            $("html").removeClass('hide');
            if(localStorage.getItem("bordered-layout-current-skin")=='dark-layout'){
                $("html").addClass("dark-layout");
                $("html").removeClass("bordered-layout");
                $("#light").remove();
            }else{
                $("html").addClass("bordered-layout");
                $("html").removeClass("dark-layout");
                $("#dark").remove();
            }
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
            @if(Session::has('error'))
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.error("{{ session('error') }}");
            @endif

            @if(Session::has('info'))
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.info("{{ session('info') }}");
            @endif

            @if(Session::has('warning'))
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.warning("{{ session('warning') }}");
            @endif

            @if(Session::has('success'))
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.success("{{ session('success') }}");
            @endif
        })
    </script>

    <?php if (Request::is('admin/settings/app/websetting*')){ ?>

        <script type="text/javascript">
            $('#website_logo').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.website_logo').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#about_product').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('#about_product_src').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#mobile_image').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('#mobile_image_img').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });


            $('#icon_1').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_1').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#icon_2').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_2').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#icon_3').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_3').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#icon_4').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_4').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });
            $('#website_bg_image').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.website_bg_image').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });
    </script>
    <?php } ?>

    <!-- BEGIN: Content-->
    @if ($errors->any())
        @foreach ($errors->all() as $error)
            <script type="text/javascript">
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.error("{{ $error }}");
            </script>
        @endforeach
    @endif


    <!-- custom js code -->
    <style type="text/css">
    .form-check.me-3.me-lg-5.permission {
    cursor: pointer;
    font-weight: 600;
    }
    input.form-check-input {
    cursor: pointer;
    font-weight: 500;
    }

    label.form-label {
        float: left;
    }

    label .required {
    color: red!important;
    }

    .main-menu.menu-dark .navigation > li.active > a {
        background: linear-gradient(118deg, #14a1a7, #14a1a77a) !important;
        box-shadow: 0 0 10px 1px #7a340238 !important;
        color: #fff !important;
        font-weight: 400 !important;
        border-radius: 4px !important;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        display: none!important;
    }

    .select2-container--default .select2-selection--single {
        height: 35px!important;
    }

    .form-check-input:checked {
        background-color: #14a1a7!important;
        border-color: #14a1a7!important;
    }

    input#reportrange {
    background: white;
    }

    input#order_delivery_date {
    background: white;
    }

    .swal-confirm-button-class {
        background-color: #14a1a7 !important; /* Set the desired background color */
    }
    </style>

    <script type="text/javascript">
        function selectAllSameData(source_class, des_class) {
            var sourceChecked = $("." + source_class + ":checked").length > 0;

            if (sourceChecked) {
                $("." + des_class).prop("checked", true);
            } else {
                $("." + des_class).prop("checked", false);
            }
        }

        function showImagePreview(input_id,preview_id,width,height) {
            console.log(width);
            console.log(height);
            $('#'+input_id).on('change', function() {
                var file = this.files[0];
                var reader = new FileReader();
                reader.onload = function(event) {
                    var img = new Image();
                    img.onload = function() {
                        $("#"+preview_id).removeClass('hide');
                        $('#'+preview_id).attr('src', event.target.result);
                    };
                    img.src = event.target.result;
                };
                reader.readAsDataURL(file);
            });
        }


        function translateByThirdParty(name,code,input_id){
            var data = {};
            data.code = code;
            data.name = name;
            data.text = $("#"+input_id).val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: base_url+'/admin/translation-by-third-party',
                type: 'POST',
                data: data,
                dataType:'json',
                success: function (response) {
                    if(response.status){
                        $("#"+input_id).val(response.data);
                        myToastr(response.message,'success');
                    }else{
                        myToastr(response.message,'error');
                    }
                },
            });
        }


        function translateByGoogle(name,code,input_id){
            var data = {};
            data.code = code;
            data.name = name;
            data.text = $("#"+input_id).val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: base_url+'/admin/translation-by-google',
                type: 'POST',
                data: data,
                dataType:'json',
                success: function (response) {
                    if(response.status){
                        $("#"+input_id).val(response.data);
                        myToastr(response.message,'success');
                    }else{
                        myToastr(response.message,'error');
                    }
                },
            });
        }

        function myToastr(msg, type) {
            toastr.remove();
            if (type == 'error') {
                toastr['error']('', msg);
            } else if (type == 'success') {
                toastr['success']('', msg);
            }
        }

        function translationKeyNotFoundError(){
            myToastr("{{__('lang.admin_google_translate_api_key_error')}}",'error');
        }
    </script>
<script>
    function showDeleteConfirmation(pagename , itemId) {
        Swal.fire({
            title: "{{__('lang.admin_swal_are_you_sure')}}",
            text: "{{__('lang.admin_swal_you_will_not_be_able_to_revert_this')}}",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "{{__('lang.admin_swal_yes_delete_it')}}",
            cancelButtonText: "{{ __('lang.admin_swal_cancel') }}",
            customClass: {
                confirmButton: 'swal-confirm-button-class'
            }
        }).then((result) => {
            if (result.isConfirmed) {

                if(pagename == 'product'){
                  window.location.href = base_url+"/admin/products-destroy/" + itemId;
                }else if(pagename == 'order-list'){
                  window.location.href = base_url+"/admin/orders-destroy/" + itemId;
                }else if(pagename == 'user'){
                  window.location.href = base_url+"/admin/user-destroy/" + itemId;
                }else if(pagename == 'driver'){
                  window.location.href = base_url+"/admin/driver-destroy/" + itemId;
                }else if(pagename == 'subadmin'){
                  window.location.href = base_url+"/admin/subadmin-destroy/" + itemId;
                }else if(pagename == 'role'){
                  window.location.href = base_url+"/admin/role-destroy/" + itemId;
                }else if(pagename == 'banner'){
                  window.location.href = base_url+"/admin/banner-destroy/" + itemId;
                }else if(pagename == 'coupon'){
                  window.location.href = base_url+"/admin/coupon-destroy/" + itemId;
                }else if(pagename == 'about_us'){
                  window.location.href = base_url+"/admin/about_us-destroy/" + itemId;
                }else if(pagename == 'holidays'){
                  window.location.href = base_url+"/admin/holidays-destroy/" + itemId;
                }else if(pagename == 'delivery_address'){
                  window.location.href = base_url+"/admin/delivery_areas-destroy/" + itemId;
                }else if(pagename == 'timeslot'){
                  window.location.href = base_url+"/admin/timeslot-destroy/" + itemId;
                }else if(pagename == 'currency'){
                  window.location.href = base_url+"/admin/currency-destroy/" + itemId;
                }else if(pagename == 'language'){
                  window.location.href = base_url+"/admin/language-destroy/" + itemId;
                }else if(pagename == 'notification'){
                  window.location.href = base_url+"/admin/notification-destroy/" + itemId;
                }else if(pagename == 'state'){
                  window.location.href = base_url+"/admin/state-destroy/" + itemId;
                }else if(pagename == 'city'){
                  window.location.href = base_url+"/admin/city-destroy/" + itemId;
                }

            }
        });
    }
    
    function showCityByStateId(state_id, div_id) {
        var state_id_value = $('#' + state_id).val();
        var city_id_value = $('#' + div_id).val();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: base_url + '/admin/get-city-by_state-id',
            type: 'POST',
            data: {
                'state_id': state_id_value,
                'city_id': city_id_value
            },
            dataType: 'json',
            success: function(response) {
                if (response.status) {
                    loadHtmlByClass(div_id, response.data);
                } else {
                    myToastr(response.message, 'error');
                }
            },
        });
    }
    
    function loadHtmlByClass(id,dataObj) {
        var html = "";
        var html = dataObj.html;
        $("."+id).html(html);
    }
</script>

</body>
</html>
