<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">{{__('lang.admin_menu_language_list')}}</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th>{{__('lang.admin_language_name')}}</th>
                               <th>{{__('lang.admin_language_placeholder')}}</th>
                               <th>{{__('lang.admin_language_direction')}}</th>
                               @can('update-languages-status')
                               <th>{{__('lang.admin_status')}}</th>
                               @endcan
                                <th>{{__('lang.admin_is_default')}}</th> 
                               <th>{{__('lang.admin_date')}}</th>
                               @canany(['update-languages','delete-languages'])
                               <th>{{__('lang.admin_table_action')}}</th>
                               @endcanany
                           </tr>
                       </thead>
                       <tbody>
                           @if(count($data) > 0)
                           @foreach($data as $res)
                           <tr>
                                <td>{{ isset($res->language_name)?$res->language_name:'--' }}</td>
                                <td>{{ isset($res->language_code)?$res->language_code:'--' }}</td>
                                <td>{{ isset($res->language_direction)?strtoupper($res->language_direction):'--' }}</td>
                                @can('update-languages-status')
                                <td>
                                    @if($res->status == 1)
                                        @php
                                        $selectedLanguage = App::getLocale();
                                        @endphp
                                        @if($selectedLanguage == $res->language_code)
                                            <span class="badge rounded-pill badge-light-primary me-1" onclick="showMsg()" style="cursor:pointer">{{__('lang.admin_active')}}</span>
                                        @else
                                            <a href="{{ url('admin/change-languages-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span>
                                            </a>
                                        @endif
                                    @else
                                        <a href="{{ url('admin/change-languages-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span></a>
                                    @endif
                                </td>
                                @endcan

                                 <td>
                                    @if($res->is_default == 1)
                                        <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_yes')}}</span>
                                    @else
                                        <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_no')}}</span>
                                    @endif
                                </td>
                      

                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                                @canany(['update-languages','delete-languages'])
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @can('update-languages')
                                            <a class="dropdown-item"  data-bs-toggle="modal" data-bs-target="#edit_language_{{$res->id}}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            @endcan
                                            @can('delete-languages')
                                               <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('language' , {{ $res->id }})">
                                                <i data-feather="trash" class="me-50"></i>
                                                <span>{{__('lang.admin_button_delete')}}</span>
                                               </a>
                                            @endcan
                                        </div>
                                    </div>

                                    <!-- Modal to add new record -->
                                    <div class="modal modal-slide-in fade" id="edit_language_{{$res->id}}">
                                        <div class="modal-dialog sidebar-sm" style="text-align: left;">
                                            <form class="add-new-record modal-content pt-0" action="{!! url('admin/languages/update/'.$res->id) !!}" method="post">
                                                @csrf
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                                <div class="modal-header mb-1">
                                                    <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_language_update')}}</h5>
                                                </div>
                                                <div class="modal-body flex-grow-1">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-Language Name">{{__('lang.admin_language_name')}} <span class="required">*</span></label>
                                                    <input type="text" class="form-control dt-full-name" id="basic-icon-Language Name" placeholder="{{__('lang.admin_language_name')}}" aria-label="{{__('lang.admin_language_name')}}" name="language_name" value="{{ isset($res->language_name)?$res->language_name:'--' }}" required />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-language_code">{{__('lang.admin_language_placeholder')}} {{$res->language_code}} <span class="required">*</span></label>
                                                        <select class="form-control dt-post" name="language_code" required/>
                                                            <option value="">{{__('lang.admin_select_language_code')}}</option>
                                                            @if(isset($languages) && !empty($languages))
                                                                @foreach($languages as $language)
                                                                    <option value="{{$language->code}}" @if($res->language_code == $language->code) selected @endif>{{$language->code}} ({{$language->name}})</option>
                                                                @endforeach
                                                            @endif
                                                        </select>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-language_direction">{{__('lang.admin_language_directon_placeholder')}} <span class="required">*</span></label>
                                                        <select class="form-control dt-post" name="language_direction" required/>
                                                            <option value="">{{__('lang.admin_select_language_direction')}}</option>
                                                            <option value="ltr" @if(isset($res->language_direction) && $res->language_direction!='') @if($res->language_direction=='ltr') selected @endif @endif>{{__('lang.admin_ltr')}}</option>
                                                            <option value="rtl" @if(isset($res->language_direction) && $res->language_direction!='') @if($res->language_direction=='rtl') selected @endif @endif>{{__('lang.admin_rtl')}}</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-check me-3 mt-2 mb-2" style="margin-right: 9rem !important;">
                                                        <input 
                                                            value="1"
                                                            {{ $res->is_default == '1' ? 'checked' : '' }}
                                                            name="is_default"
                                                            class="form-check-input"
                                                            type="checkbox"
                                                            id="language"
                                                            data-permission="language"
                                                        />
                                                        <label class="form-check-label" for="language">{{ __('lang.admin_is_default_language') }}</label>
                                                    </div>
                                                    <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_update')}}</button>
                                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                                @endcanany
                           </tr>
                           @endforeach
                           @else
                           <tr>
                               <td colspan="6" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                           </tr>
                           @endif
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
