@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_language')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_language')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            @can('add-languages')
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_language_add')}}</span>
                    </button>
                </div>
            </div>
            @endcan
        </div>
        @include('languages.table')
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('languages.store') !!}" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_language_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-language_name">{{__('lang.admin_language_name')}} <span class="required">*</span></label>
                    <input type="text" id="basic-icon-default-language_name" class="form-control dt-language_name" placeholder="{{__('lang.admin_language_name')}}" aria-label="{{__('lang.admin_language_name')}}" name="language_name" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-language_code">{{__('lang.admin_language_code_placeholder')}} <span class="required">*</span></label>
                    <select class="form-control dt-post" name="language_code" id="language_code_sel" required >
                        <option value="">{{__('lang.admin_select_language_code')}}</option>
                        @if(isset($languages) && count($languages))
                        @foreach($languages as $language)
                            <option value="{{$language->code}}">{{$language->code}} ({{$language->name}})</option>
                        @endforeach
                        @endif
                    </select>
                </div>

                <div class="mb-1">
                    <label class="form-label" for="basic-icon-language_direction">{{__('lang.admin_language_directon_placeholder')}} <span class="required">*</span></label>
                    <select class="form-control dt-post" name="language_direction" required >
                        <option value="">{{__('lang.admin_select_language_direction')}}</option>
                        <option value="ltr">{{__('lang.admin_ltr')}}</option>
                        <option value="rtl">{{__('lang.admin_rtl')}}</option>
                    </select>

                <div class="form-check me-3 me-lg-5 mt-2">
                  <input name="is_default" class="form-check-input" type="checkbox" data-permission="languauge"/>
                  <label class="form-check-label" for="languauge">{{__('lang.admin_is_default_language')}}</label>
                </div>


                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
<!-- Select2 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
<script>
  $("#language_code_sel").select2({
      placeholder: "{{__('lang.admin_select_language_code')}}",
      allowClear: true
  });
  
  function showMsg(){
      toastr.warning("{{__('lang.admin_you_can_not_deactive_the_selected_language_change_to_another_to_do_this')}}");
  }
</script>

@endsection