<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">{{__('lang.admin_keyword_list')}}</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                                <th>{{__('lang.admin_keyword_group')}}</th>
                                <th>{{__('lang.admin_keyword_name')}}</th>
                                <th>{{__('lang.admin_keyword_value')}}</th>
                                <th>{{__('lang.admin_keyword_lang_code')}}</th>
                                @can('update-keywords')
                                <th>{{__('lang.admin_table_action')}}</th>
                                @endcan
                           </tr>
                       </thead>
                       <tbody>
                           @if(count($data) > 0)
                           @foreach($data as $res)
                           <tr>
                                <td>
                                    @if($res->group=='api' || $res->group=='app' || $res->group=='mobile')
                                        Mobile
                                    @elseif($res->group=='admin')
                                        Admin
                                    @elseif($res->group=='web' || $res->group=='website')
                                        Web
                                    @else
                                       --
                                    @endif
                                    <!-- {{ isset($res->group)?$res->group:'--' }} -->
                                </td>
                                <td>{{ isset($res->keyword)?$res->keyword:'--' }}</td>
                                <td><?php echo $res->value; ?></td>
                                <td>{{ isset($res->lang_code)?$res->lang_code:'--' }}</td>
                                @can('update-keywords')
                                <td>
                                    <a href="{{ route('keywords.edit', $res->keyword) }}">
                                        <i data-feather="edit-2" class="me-50"></i>
                                    </a>
                                </td>
                                @endcan
                           </tr>
                           @endforeach
                           @else
                           <tr>
                               <td colspan="6" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                           </tr>
                           @endif
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
