@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-12 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="row">
                        <div class="col-md-8">
                            <h2 class="content-header-title float-start mb-0">{{__('lang.admin_keyword_language')}}</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{__('lang.admin_keyword_language')}}
                                    </li>
                                </ol>
                            </div>
                        </div>
                        <div class="col-md-4">
                             @can('add-keywords')
                            <div class="content-header-right text-md-end">
                                <div class="mb-1 breadcrumb-right">
                                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                                        <i data-feather="plus" class="me-25"></i>
                                        <span>{{__('lang.admin_leyword_add')}}</span>
                                    </button>
                                </div>
                            </div>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
                <div class="dt-action-buttons text-end">
                    <form id="formData" method="get">
                        <div class="row">
                            <div class="form-group col-sm-3">
                                <input type="text" name="search" placeholder="{{__('lang.admin_serch_by_keyword')}}" class="form-control" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                            </div>
                            <div class="form-group col-sm-3">
                                <select class="form-select" name="group" id="group">
                                    <option value="">{{__('lang.admin_platform')}}</option>
                                    <option value="web" @if(isset($_GET['group'])) @if($_GET['group']=='web') selected @endif @endif>{{__('lang.admin_web')}}</option>
                                    <option value="admin" @if(isset($_GET['group'])) @if($_GET['group']=='admin') selected @endif @endif>{{__('lang.admin_admin')}}</option>
                                    <option value="api" @if(isset($_GET['group'])) @if($_GET['group']=='api') selected @endif @endif>{{__('lang.admin_mobile')}}</option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <select class="form-select" name="lang_code" id="lang_code" style="width: -webkit-fill-available">
                                    <option value="">{{__('lang.admin_select_language')}}</option>
                                    @foreach($language as $lang)
                                        <option value="{{$lang->language_code}}" @if(isset($_GET['lang_code'])) @if($_GET['lang_code']==$lang->language_code) selected @endif @endif>{{$lang->language_name}} ({{$lang->language_code}})</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                                <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @include('keywords.table')
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" id="checkKeywordExist">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_keyword_top_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-language_name">{{__('lang.admin_group_name')}} <span class="required">*</span></label>
                    <select class="form-control" name="group" required>
                        <option value="">{{__('lang.admin_group')}}</option>
                        <option value="web">{{__('lang.admin_web')}}</option>
                        <option value="admin">{{__('lang.admin_admin')}}</option>
                        <option value="api">{{__('lang.admin_mobile')}}</option>
                    </select>
                </div>
                <div class="col-sm-12">
                    <div class="mb-1">
                        <label class="form-label" for="keyword">{{__('lang.admin_keyword')}} <span class="required">*</span></label>
                        <input class="form-control" id="keyword" name="keyword" placeholder="{{__('lang.admin_keyword_placeholder')}}" required />
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="mb-1">
                        <label class="form-label" for="value">{{__('lang.admin_value')}} <span class="required">*</span></label>
                        <input class="form-control" id="value" name="value" placeholder="{{__('lang.admin_value_placeholder')}}" required />
                    </div>
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>

    </div>
</div>
<!-- END: Content-->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script>
    let CLICK = 0;
    $("#checkKeywordExist").submit(function(event) {
        event.preventDefault();
        if (CLICK === 0) {
            CLICK = 1;
            $.ajax({
                type: "POST",
                url: $(this).attr('action'), // Use the action attribute of the form
                data: $(this).serialize(),
                success: function(response) {
                    console.log(response);
                    if (response.status === true) {
                        toastr.success(response.message);
                        setTimeout(function() {
                            window.location.reload();
                        }, 1000);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    toastr.error("{{__('lang.admin_an_error_occurred')}}" + textStatus);
                },
                complete: function() {
                    CLICK = 0;
                }
            });
        }
    });
</script>
@endsection
