@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <!-- <h2 class="content-header-title float-start mb-0">{{__('lang.admin_keyword_text')}} {{$id}}</h2> -->
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/keywords*') ? 'active' : '' }}"><a href="{!! route('keywords.index') !!}">{{__('lang.admin_keyword_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_keyword_update')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($languages, ['method' => 'PATCH','route' => ['keywords.update', $id]]) !!}
                                @csrf
                                <input type="hidden" name="keyword" value="{{$id}}">
                                <div class="row">
                                    @foreach($languages as $row) 
                                        @if($row->details)
                                            <input type="hidden" name="language_code[]" value="{{$row->language_code}}">
                                            <div class="col-md-4">
                                                <div class="mb-1">
                                                    <label class="form-label" for="username">{{__('lang.admin_value_in')}} {{$row->language_name}}</label>
                                                    <input type="text" class="form-control" placeholder="{{__('lang.admin_value_in')}} {{$row->language_name}}" value="{{$row->details->value}}" name="keyword_value[]" />
                                                </div>
                                            </div>
                                        @endif 
                                    @endforeach
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('keywords.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection