@extends('layouts.site-app')
@section('sitecontent')

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<section class="headerbg">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    @include('partials.site.home-banner')
</section>

<section class="about-product-bg">
    <div class="container">
        <div class="about-product-toprow mt-5">
            <ul>
                <li>
                    <span><img src="{{asset('site-assets/images/website/')}}/{{setting('icon_1')}}" class="top-four-image-dimentions" onerror="this.src='{{asset('site-assets/images/step-icon.png')}}'"  /></span>
                    <h3>{{__('lang.home_product_filtration')}}</h3>
                    <p>
                        <?php echo __('lang.home_product_filtration_description'); ?>
                    </p>
                </li>
                <li>
                    <span><img src="{{asset('site-assets/images/website/')}}/{{setting('icon_2')}}" class="top-four-image-dimentions" onerror="this.src='{{asset('site-assets/images/step-icon.png')}}'"  /></span>
                    <h3>{{__('lang.home_product_max_purity')}}</h3>
                    <p>
                        <?php echo __('lang.home_product_max_purity_description'); ?>
                    </p>
                </li>
                <li>
                    <span><img src="{{asset('site-assets/images/website/')}}/{{setting('icon_3')}}" class="top-four-image-dimentions" onerror="this.src='{{asset('site-assets/images/step-icon.png')}}'"  /></span>
                    <h3>{{__('lang.home_product_cholorine_free')}}</h3>
                    <p>
                        <?php echo __('lang.home_product_cholorine_free_description'); ?>
                    </p>
                </li>
                <li>
                    <span><img src="{{asset('site-assets/images/website/')}}/{{setting('icon_4')}}" class="top-four-image-dimentions" onerror="this.src='{{asset('site-assets/images/step-icon.png')}}'"  /></span>
                    <h3>{{__('lang.home_product_soft_drink')}}</h3>
                    <p>
                        <?php echo __('lang.home_product_soft_drink_description'); ?>
                    </p>
                </li>
            </ul>
        </div>
        <div class="about-product-bottomrow">
            <div class="row home-about-alignment">
                <div class="col-md-5">
                    <div class="about-product-img"><img src="{{asset('site-assets/images/website/')}}/{{setting('about_product')}}" onerror="this.src='{{asset('site-assets/images/about-poduct.png')}}'" /></div>
                </div>
                <div class="col-md-7">
                    <span><a class="home_about_product-anchor">{{__('lang.home_about_product')}}</a><span>
                    <h1 class="mt-12">{{__('lang.home_about_product_chemical')}}</h1>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="about-product-text">
                                <h4>{{__('lang.home_about_product_Calcium')}}</h4>
                                <h5>{{__('lang.home_about_product_Calcium_mg_quntity')}}</h5>
                                <p>
                                    <?php echo __('lang.home_about_product_Calcium_description'); ?>
                                </p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="about-product-text">
                                <h4>{{__('lang.home_about_product_Calcium2')}}</h4>
                                <h5>{{__('lang.home_about_product_Calcium_mg_quntity2')}}</h5>
                                <p>
                                    <?php echo __('lang.home_about_product_Calcium_description2'); ?>
                                </p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="about-product-text">
                                <h4>{{__('lang.home_about_product_Calcium3')}}</h4>
                                <h5>{{__('lang.home_about_product_Calcium_mg_quntity3')}}</h5>
                                <p>
                                    <?php echo __('lang.home_about_product_Calcium_description3'); ?>
                                </p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="about-product-text">
                                <h4>{{__('lang.home_about_product_Calcium4')}}</h4>
                                <h5>{{__('lang.home_about_product_Calcium_mg_quntity4')}}</h5>
                                <p>
                                    <?php echo __('lang.home_about_product_Calcium_description4'); ?>
                                </p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="about-product-text">
                                <h4>{{__('lang.home_about_product_Calcium5')}}</h4>
                                <h5>{{__('lang.home_about_product_Calcium_mg_quntity5')}}</h5>
                                <p>
                                    <?php echo __('lang.home_about_product_Calcium_description5'); ?>
                                </p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="about-product-text">
                                <h4>{{__('lang.home_about_product_Calcium6')}}</h4>
                                <h5>{{__('lang.home_about_product_Calcium_mg_quntity6')}}</h5>
                                <p>
                                    <?php echo __('lang.home_about_product_Calcium_description6'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@if(count($products) > 0)
<section class="populargoods" id="populargoods">
    <div class="container">
        <span class="home-about-assorment"><span>
        <h1 class="mt-10">{{__('lang.home_about_product_popular_goods')}}</h1>
        @if(Session::has('message'))
            <div class="col-lg-12">
                <div class="alert alert-success" role="alert">
                  {{ Session::get('message') }}
                </div>
            </div>
        @endif
        <div id="owl-carousel" class="owl-carousel owl-theme" style="@if(isset($_COOKIE['lang_code'])) @if($_COOKIE['lang_code']=='ar') direction: ltr; @endif @endif">
            @foreach($products as $row)
                <div class="item">
                    <div class="populargoods-box">
                        <div class="populargoods-img">
                            <img src="{{asset('app-assets/images/products')}}/{{$row->image}}" alt="{{$row->name}}" style="height:210px;border-radius: 10px;" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';" />
                        </div>
                        <h6>{{\Helpers::getLimitedProductName($row->name)}}</h6>
                        <h5>@if($row->discount_price>0) {{\Helpers::currency($row->discount_price)}} @else {{\Helpers::currency($row->price)}} @endif</h5>
                       {{--  @auth
                            @if($row->cart_info)
                                <a href="javascript:void(0)"  class="addproduct" style="background: #af7ab380;" disabled data-id="{{$row->id}}"><img src="{{asset('site-assets/images/plusico.png')}}" alt="{{$row->name}}" /></a>
                            @else
                                <a href="{{url('add-to-cart')}}?product_id={{$row->id}}" class="addproduct"><img src="{{asset('site-assets/images/plusico.png')}}" alt="{{$row->name}}" /></a>

                            @endif
                        @endauth
                        @guest
                            <a href="{{url('signin')}}" class="addproduct" data-id="{{$row->id}}"><img src="{{asset('site-assets/images/plusico.png')}}" alt="{{$row->name}}" /></a>
                        @endguest --}}
                        @auth
                            @if($row->cart_info)
                                <button type="button"
                                        class="addproduct"
                                        style="background: #af7ab380;"
                                        disabled
                                        data-id="{{$row->id}}">
                                    <img src="{{asset('site-assets/images/plusico.png')}}" alt="{{$row->name}}" />
                                </button>
                            @else
                                <button type="button"
                                        class="addproduct"
                                        data-id="{{$row->id}}">
                                    <img src="{{asset('site-assets/images/plusico.png')}}" alt="{{$row->name}}" />
                                </button>
                            @endif
                        @endauth
                        @guest
                            <a href="{{url('signin')}}" class="addproduct" data-id="{{$row->id}}">
                                <img src="{{asset('site-assets/images/plusico.png')}}" alt="{{$row->name}}" />
                            </a>
                        @endguest
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
@endif
@include('index_product_popup')
<section class="healthlylife-bg">
    <div class="container">
        <div class="healthlylife-video width-full-left" style="position: relative;">
            <a href="javascript:;">
                @php
                    // Check if a video URL is set in the settings
                    $videoUrl = setting('youtube_video_url');

                    // If no URL is set, fallback to a local video file
                    if (!$videoUrl) {
                        $videoUrl = asset('/uploads/default-video.mp4'); // Adjust the path as needed
                    }
                @endphp

                @if(str_contains($videoUrl, 'youtube.com'))
                    <!-- Embed YouTube video -->
                    <iframe id="youtube_video" src="{{ $videoUrl }}" style="width:100%; height: 650px;" allowfullscreen></iframe>
                @else
                    <!-- Embed local video file -->
                    <video id="local_video" controls>
                        <source src="{{ $videoUrl }}" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                @endif
            </a>
            <p>{{ __('lang.home_about_watch_your_video') }}</p>
        </div>

        <div class="healthlylife-content width-full-left mt-20">
            <h1 class="healthlylife-content-heading float-left">
                <?php echo __('lang.home_about_water_quality'); ?>
            </h1>
            <h6 class="healthlylife-content-heading-h6">{{__('lang.home_about_water_quality_description')}}</h6>
            <hr>
            <div class="row padding-0">
                <!-- col-md-12 col-12 display-flex -->
                <div class="col-md-3 col-12 padding-for-mobile padding-0">
                    <p>
                        <span><img src="{{asset('site-assets/images/plusicon.png')}}"  /></span>{{__('lang.home_about_water_quality_strong_immunity')}}
                    </p>
                </div>
                <div class="col-md-3 col-12 padding-for-mobile padding-0">
                    <p>
                        <span><img src="{{asset('site-assets/images/plusicon.png')}}"  /></span>{{__('lang.home_about_water_quality_good_degistion')}}
                    </p>
                </div>
                <div class="col-md-3 col-12 padding-for-mobile padding-0">
                    <p>
                        <span><img src="{{asset('site-assets/images/plusicon.png')}}"  /></span>{{__('lang.home_about_water_quality_feeling')}}
                    </p>
                </div>
                <div class="col-md-3 col-12 padding-for-mobile padding-0">
                    <p>
                        <span><img src="{{asset('site-assets/images/plusicon.png')}}"  /></span>{{__('lang.home_about_water_quality_strong_immunity')}}
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="downloadapp-bg">
    <div class="container">
        <div class="downloadapp-img"><img src="{{asset('site-assets/images/website/')}}/{{setting('mobile_image')}}" onerror="this.src='{{asset('site-assets/images/downloadapp.png')}}'" style="object-fit: contain;height: 500px;width: 100%;"/></div>
        <div class="downloadapp-content">
            <span class="width-full-left"><a class="downloadapp-content-anchor">{{__('lang.home_about_call_ordering')}}</a><span>
            <h1 class="mt-20"><?php echo __('lang.home_about_call_ordering_description'); ?></h1>
            <div class="downloadapp-content-btn-new mt-5">
                @if(setting('apple_download_url'))
                <a href="{{setting('apple_download_url')}}" class="" target="_blank">
                    <img src="{{ asset('uploads/Apple.png') }}">
                </a>
                @endif
                @if(setting('android_download_url'))
                <a href="{{setting('android_download_url')}}" target="_blank" class="">
                    <img src="{{ asset('uploads/Play.png') }}">
                </a>
                @endif
            </div>
        </div>
    </div>
</section>
<div class="modal" id="watch_video">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <iframe src="{{setting('youtube_video_url')}}" style="width:100%;height: 400px;"></iframe>
            </div>
        </div>
    </div>
</div>
<footer class="footer">
    @include('partials.site.footer')
</footer>
<!-- END: Content-->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        $('button.addproduct:not([disabled])').on('click', function() {
            $('#main_script').remove();
            var productId = $(this).data('id'); // Assuming button has data-product-id attribute
            var url = "{{ url('products/get-product-details') }}";
            $.ajax({
                url: url,
                method: 'GET',
                data: { id: productId },
                success: function(data) {
                    console.log(data);
                    if (data.status =='success'){
                        $('#productModal').html(data.html);
                        $('#productModal').modal('show');
                        $('#productimg').html('<img src="' + data.image + '" alt="' + data.name + '" />');
                        $('.product_name').text(data.name);
                        $('.product_price').text(data.price);
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: data.message,
                            confirmButtonText: "{{ __('lang.ok') }}",
                        });
                        return;
                    }
                    if (data.status === 'error') {
                        Swal.fire({
                            title: 'Error!',
                            text: data.message,
                            confirmButtonText: "{{ __('lang.ok') }}",
                        });
                        return;
                    }

                },
                error: function(xhr, status, error) {
                    // Log any AJAX errors for debugging purposes
                    console.error(xhr.responseText);
                    Swal.fire({
                        title: 'Error!',
                        text: 'Something went wrong while fetching product details.',
                        confirmButtonText: "{{ __('lang.ok') }}",
                    });
                }
            });

        });
    });


    var player;

    // This function creates a new YouTube player object
    function onYouTubeIframeAPIReady() {
        player = new YT.Player('youtube_video', {
        events: {
            'onStateChange': onPlayerStateChange
        }
        });
    }

    // Function to handle player state changes
    function onPlayerStateChange(event) {
        if (event.data == YT.PlayerState.PLAYING) {
        $("#play-button").hide();
        } else if (event.data == YT.PlayerState.PAUSED || event.data == YT.PlayerState.ENDED) {
        $("#play-button").show();
        }
    }

    $(document).ready(function() {
        $("#play-button").click(function() {
            if (player.getPlayerState() == YT.PlayerState.PLAYING) {
                player.pauseVideo();
            } else {
                player.playVideo();
            }
        });
    });
</script>
<!-- <script>
    $(document).ready(function() {
        const videoFrame = $("#youtube_video");
        const playButton = $("#play_button");

        playButton.on("click", function () {
            if (videoFrame[0].contentWindow && videoFrame[0].contentWindow.postMessage) {
                videoFrame[0].contentWindow.postMessage('{"event":"command","func":"playVideo","args":""}', '*');
                $("#play_button").hide();
            }
        });

        videoFrame.on("click", function () {
            alert(1);
            if (videoFrame[0].contentWindow && videoFrame[0].contentWindow.postMessage) {
                videoFrame[0].contentWindow.postMessage('{"event":"command","func":"pauseVideo","args":""}', '*');
                $("#play_button").show();
            }
        });
    });
</script> -->
@endsection
