<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orders PDF Export</title>
<style>
    body {
        font-family: Arial, sans-serif;
        font-size: 10px; /* Adjust font size as needed */
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th, td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 4px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    th {
        background-color: #f2f2f2;
    }

    caption {
        caption-side: top;
        font-size: 16px;
        font-weight: bold;
        margin-bottom: 10px;
    }
</style>

</head>
<body>
    <table>
        <caption>Revenue</caption>
        <thead>
            <tr>
                <th>ID</th>
                <th>Order ID</th>
                <th>User Name</th>
                <th>User Email</th>
                <th>User Phone</th>
                <th>Driver Name</th>
                <th>Product Name</th>
                <th>Order Product Quantity</th>
                <th>Order Product Total</th>
                <th>Delivery Date</th>
                <th>Order Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
                <tr>
                    <td>{{ $order->id }}</td>
                    <td>{{ $order->order_id }}</td>
                    <td>{{ $order->user_name }}</td>
                    <td>{{ $order->user_email }}</td>
                    <td>{{ $order->user_phone }}</td>
                    <td>{{ $order->driver_name }}</td>
                    <td>{{ $order->product_name }}</td>
                    <td>{{ $order->order_product_quantity }}</td>
                    <td>{{ $order->order_product_total_delivery_amount }}</td>
                    <td>{{ $order->delivery_date }}</td>
                    <td>{{ $order->order_status }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
