<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orders PDF Export</title>
<style>
    body {
        font-family: Arial, sans-serif;
        font-size: 10px; /* Adjust font size as needed */
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th, td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 4px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    th {
        background-color: #f2f2f2;
    }

    caption {
        caption-side: top;
        font-size: 16px;
        font-weight: bold;
        margin-bottom: 10px;
    }
</style>

</head>
<body>
    <table>
        <caption>Orders</caption>
        <thead>
            <tr>
                <th>ID</th>
                <th>User Name & User Phone</th>
                <!-- <th>User Email</th> -->
                <th>Order Status</th>
                <th style="max-width:0%;">Delivery Address</th>
                <th>Payment Status</th>
                <!-- <th>Promotional Discount</th> -->
                <!-- <th>Is Coupon Applied</th> -->
                <!-- <th>Coupon Code</th> -->
                <!-- <th>Subtotal</th> -->
                <th>Final Amount</th>
                <!-- <th>Tax</th> -->
                <!-- <th>Delivery Fee</th> -->
                <th>Payment Method</th>
                <th>Timeslot Name</th>
                <!-- <th>Created At</th> -->
                <!-- <th>Updated At</th> -->
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
                <tr>
                    <td>{{ $order->id }}</td>
                    <td>
                        {{ $order->user_name }}</br>
                        {{ $order->user_phone }}
                    </td>
                    <!-- <td>{{ $order->user_email }}</td> -->
                    <td>{{ $order->order_status }}</td>
                    <td>{{ $order->delivery_address }}</td>
                    <td>{{ $order->payment_status }}</td>
                    <!-- <td>{{ $order->promotional_disount }}</td> -->
                    <!-- <td>{{ $order->is_coupon_applied }}</td> -->
                    <!-- <td>{{ $order->coupon_code }}</td> -->
                    <!-- <td>{{ $order->subtotal }}</td> -->
                    <td>{{ $order->final_amount }}</td>
                    <!-- <td>{{ $order->tax }}</td> -->
                    <!-- <td>{{ $order->delivery_fee }}</td> -->
                    <td>{{ $order->payment_method }}</td>
                    <td>{{ $order->timeslot_name }}</td>
                    <!-- <td>{{ $order->created_at }}</td> -->
                    <!-- <td>{{ $order->updated_at }}</td> -->
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
