@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_drivers')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_driver_list')}}
                                    </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            @can('add-driver') 
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_driver_add')}}</span>
                    </button>
                </div>
            </div>
            @endcan
            
        </div>

        <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
            <div class="dt-action-buttons text-end">
                <form id="formData" method="get">
                    <div class="row">
                        <div class="form-group col-sm-5">
                            <input type="text" name="search" class="form-control" placeholder="{{__('lang.admin_search_by_name_email_phone')}}" id="search" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                        </div>

                         <div class="col-md-4">
                            <select class="form-select" name="status" id="status" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_status')}}</option>
                                @foreach($filter['status'] as $value => $sts)
                                <option value="{{ $value }}" @if(isset($_GET['status']) && $_GET['status'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                            @endforeach
                            </select>
                        </div>

                        <div class="form-group col-sm-3" style="text-align: left;">
                            <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                            <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        @include('drivers.table')
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('drivers.store') !!}" id="add-record" onsubmit="return validateAddForm('add-record');" enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_driver_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <input type="hidden" name="type" value="driver"/>
                <div class="mb-1">
                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                    <div class="col-12 d-flex mt-1 px-0">
                        <label class="btn btn-primary me-75 mb-0" for="change-picture">
                            <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                            <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                            <span class="d-block d-sm-none">
                                <i class="me-0" data-feather="edit"></i>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_name')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="John Doe" aria-label="John Doe" name="name" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">{{__('lang.admin_email')}} <span class="required">*</span></label>
                    <input type="text" id="basic-icon-default-email" class="form-control dt-email" placeholder="john.doe@example.com" aria-label="john.doe@example.com" name="email" required />
                    <small class="form-text"> {{__('lang.admin_email_placeholder')}} </small>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-phone">{{__('lang.admin_phone')}} <span class="required">*</span></label>
                    <input type="text" id="basic-icon-default-phone" class="form-control dt-post" placeholder="1212121212" aria-label="{{__('lang.admin_phone')}}" name="phone" required maxlength="10"/>
                </div>
                
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-password">{{__('lang.admin_password')}} <span class="required">*</span></label>
                    <input type="password" id="basic-icon-default-password" class="form-control" placeholder="*******" aria-label="{{__('lang.admin_password')}}" name="password" required />
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
<script>
    function validateAddForm(formid) {
        var $form = $("#" + formid);
        var data = new FormData($form[0]);

        if (data.get('password').length < 8) {
            myToastr("{{__('lang.admin_password_must_be_atleast_8_characters')}}", 'error');
            return false;
        }
    }
</script>
@endsection