@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_drivers')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/drivers*') ? 'active' : '' }}"><a href="{!! route('drivers.index') !!}">{{__('lang.admin_driver_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_driver_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <!-- users edit start -->
                                {!! Form::model($driver, ['method' => 'PATCH', 'enctype' => 'multipart/form-data', 'route' => ['drivers.update', $driver->id], 'id' => 'edit-record', 'onsubmit' => 'return validateEditForm("edit-record");']) !!}
                                @csrf
                                <div class="d-flex mb-2">
                                    @if($driver->image!='')
                                    <img src="{{asset('app-assets/images/drivers/'.$driver->image)}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';"/>
                                    @else
                                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    @endif
                                    <div class="mt-50">
                                    <h4>{{$driver->name}}</h4>
                                        <div class="col-12 d-flex mt-1 px-0">
                                            <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                                <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                                                <span class="d-block d-sm-none">
                                                    <i class="me-0" data-feather="edit"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_name')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_name')}}" value="{{$driver->name}}" name="name" id="username" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email">{{__('lang.admin_email')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_email')}}" value="{{$driver->email}}" name="email" id="email" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="phone">{{__('lang.admin_phone')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_phone')}}" value="{{$driver->phone}}" name="phone" id="phone" required maxlength="10" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="password">{{__('lang.admin_password')}}</label>
                                            <input type="password" class="form-control" placeholder="{{__('lang.admin_password')}}" name="password" id="password" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($driver->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($driver->status == 0) selected  @endif>{{__('lang.admin_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('drivers.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->
<script>
    function validateEditForm(formid) {

    var $form = $("#" + formid);
    var data = new FormData($form[0]);

    if(data.get('password') !=''){
        if (data.get('password').length < 8) {
            myToastr('The password must be at least 8 characters.', 'error');
            return false;
        }
    }
}
</script>
@endsection