<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">{{__('lang.admin_delivery_area_list')}}</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th>{{__('lang.admin_table_sno')}}</th>
                               <th>{{__('lang.admin_state')}}</th>
                               <th>{{__('lang.admin_city')}}</th>
                               <th>{{__('lang.admin_location_name')}}</th>
                               <th>{{__('lang.admin_zip_code')}}</th>
                               @can('update-delivery_area-status')
                               <th>{{__('lang.admin_status')}}</th>
                               @endcan
                               @canany(['delete-delivery_area','update-delivery_area',])
                               <th>{{__('lang.admin_table_action')}}</th>
                               @endcanany
                           </tr>
                       </thead>
                       <tbody>
                        <?php $i=0; ?>
                           @if(count($data) > 0)
                           @foreach($data as $res)
                           <?php $i++; ?>
                           <tr>
                               <td>{{$i}}</td>
                               <td>{{ isset($res->state) ? $res->state->state_name : '--' }}</td>
                               <td>{{ isset($res->cities) ? $res->cities->city_name : '--' }}</td>
                               <td>{{ isset($res->location_name)?$res->location_name:'--' }}</td>
                               <td>{{ isset($res->zip_code)?$res->zip_code:'--' }}</td>
                               @can('update-delivery_area-status')
                               <td>
                                   @if($res->status == 1)
                                       <a href="{{ url('admin/change-delivery-area-status/'.$res->id) }}">
                                           <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span></a>
                                   @else
                                       <a href="{{ url('admin/change-delivery-area-status/'.$res->id) }}">
                                           <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span></a>
                                   @endif
                               </td>
                               @endcan
                               @canany(['delete-delivery_area','update-delivery_area',])
                               <td>
                                   <div class="dropdown">
                                       <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                           <i data-feather="more-vertical"></i>
                                       </button>
                                       <div class="dropdown-menu">
                                           @can('update-delivery_area')
                                           <a class="dropdown-item" href="{{ route('delivery_areas.edit', $res->id) }}">
                                               <i data-feather="edit-2" class="me-50"></i>
                                               <span>{{__('lang.admin_button_edit')}}</span>
                                           </a>
                                           @endcan
                                           @can('delete-delivery_area')
                                               <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('delivery_address' , {{ $res->id }})">
                                                <i data-feather="trash" class="me-50"></i>
                                                <span>{{__('lang.admin_button_delete')}}</span>
                                                </a>
                                           @endcan
                                       </div>
                                   </div>
                               </td>
                               @endcanany
                           </tr>
                           @endforeach
                           @else
                           <tr>
                               <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                           </tr>
                           @endif
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                   <div class="pagination" style="float: right;">
                       {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                   </div>
               </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
