<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">{{__('lang.admin_state_list')}}</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th>{{__('lang.admin_table_sno')}}</th>
                               <th>{{__('lang.admin_state_name')}}</th>
                               @can('update-delivery_area-status')
                               <th>{{__('lang.admin_status')}}</th>
                               @endcan
                               @canany(['delete-delivery_area','update-delivery_area',])
                               <th>{{__('lang.admin_table_action')}}</th>
                               @endcanany
                           </tr>
                       </thead>
                       <tbody>
                        <?php $i=0; ?>
                           @if(count($data) > 0)
                           @foreach($data as $res)
                           <?php $i++; ?>
                           <tr>
                               <td>{{$i}}</td>
                               <td>{{ isset($res->state_name)?$res->state_name:'--' }}</td>
                               @can('update-delivery_area-status')
                               <td>
                                   @if($res->status == 1)
                                       <a href="{{ url('admin/change-state-status/'.$res->id) }}">
                                           <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span></a>
                                   @else
                                       <a href="{{ url('admin/change-state-status/'.$res->id) }}">
                                           <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span></a>
                                   @endif
                               </td>
                               @endcan
                               @canany(['delete-delivery_area','update-delivery_area',])
                               <td>
                                   <div class="dropdown">
                                       <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                           <i data-feather="more-vertical"></i>
                                       </button>
                                       <div class="dropdown-menu">
                                           @can('update-delivery_area')
                                           <a class="dropdown-item" type="button" data-bs-toggle="offcanvas" data-bs-target="#edit-new-record_{{$res->id}}" aria-controls="edit-new-record_{{$res->id}}" title="{{__('lang.admin_edit')}}">
                                               <i data-feather="edit-2" class="me-50"></i>
                                               <span>{{__('lang.admin_button_edit')}}</span>
                                           </a>
                                           @endcan
                                           @can('delete-delivery_area')
                                               <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('state' , {{ $res->id }})">
                                                <i data-feather="trash" class="me-50"></i>
                                                <span>{{__('lang.admin_button_delete')}}</span>
                                                </a>
                                           @endcan
                                       </div>
                                   </div>
                                   <div class="offcanvas offcanvas-end" id="edit-new-record_{{$res->id}}">
                                        <div class="offcanvas-header border-bottom">
                                            <h5 class="offcanvas-title" id="exampleModalLabel">{{__('lang.admin_edit_state')}}</h5>
                                            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                                        </div>
                                        <div class="offcanvas-body flex-grow-1">
                                            <form class="add-new-record pt-0 row g-2" id="edit-record" action="{!! route('state.update') !!}" method="POST"> 
                                            @csrf 
                                                <div class="col-sm-12">
                                                    <input type="hidden" name="id" value="{{$res->id}}">
                                                    <div class="mb-1">
                                                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_state_name')}} <span class="required">*</span></label>
                                                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="{{__('lang.admin_state_name_placeholder')}}" name="state_name" value="{{$res->state_name}}" required>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12">
                                                    <button type="submit" class="btn btn-primary data-submit me-sm-3 me-1" style="float:inline-start">{{__('lang.admin_button_save_changes')}}</button>
                                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">{{__('lang.admin_button_cancel')}}</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                               </td>
                               @endcanany
                           </tr>
                           @endforeach
                           @else
                           <tr>
                               <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                           </tr>
                           @endif
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                   <div class="pagination" style="float: right;">
                       {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                   </div>
               </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>