@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-body">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_delivery_areas')}}</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a
                                            href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{__('lang.admin_delivery_area_list')}}
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                @can('add-delivery_area')
                <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                    <div class="mb-1 breadcrumb-right">
                        <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal"
                            data-bs-target="#modals-slide-in">
                            <i data-feather="plus" class="me-25"></i>
                            <span>{{__('lang.admin_delivery_area_add')}}</span>
                        </button>
                    </div>
                </div>
                @endcan
            </div>

              <div class="content-header-right col-md-12 col-12 d-md-block mb-2">
                <div class="dt-action-buttons">
                    <form id="formData" method="get">
                        <div class="row">

                                <div class="col-md-12 row">

                                    <div class="col-md-4">
                                       <input type="text" name="search" class="form-control" placeholder="{{__('lang.admin_search_by_location_name_or_zipcode')}}" id="search" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <select class="form-select" name="state_id" id="state_id" style="width: -webkit-fill-available">
                                            <option value="">{{__('lang.admin_select_state')}}</option>
                                            @foreach($filter['state'] as $row)
                                                <option value="{{ $row->id }}" @if(isset($_GET['state_id']) && $_GET['state_id'] == $row->id) selected @endif>{{$row->state_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <select class="form-select" name="city_id" id="city_id" style="width: -webkit-fill-available">
                                            <option value="">{{__('lang.admin_select_state')}}</option>
                                            @foreach($filter['city'] as $row)
                                                <option value="{{ $row->id }}" @if(isset($_GET['city_id']) && $_GET['city_id'] == $row->id) selected @endif>{{$row->city_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-md-4 mt-2">
                                        <select class="form-select" name="status" id="status" style="width: -webkit-fill-available">
                                            <option value="">{{__('lang.admin_status')}}</option>
                                            @foreach($filter['status'] as $value => $sts)
                                            <option value="{{ $value }}" @if(isset($_GET['status']) && $_GET['status'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                                        @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-4 mt-2" style="text-align: left;">
                                        <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                                        <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                                    </div>

                                </div>


                              

                        </div>
                    </form>
                </div>
            </div>

            @include('delivery_areas.table')
        </div>
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('delivery_areas.store') !!}"
            enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_delivery_area_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <!--Hidden Inp-->
                <input type="hidden" name="country" id="country">
                <input type="hidden" name="city" id="city">
                <input type="hidden" name="region" id="region">
                <input type="hidden" id="latitude" name="latitude"/>
                <input type="hidden" id="longitude" name="longitude"/>
            
                <div class="col-sm-12">
                    <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_state_name')}} <span class="required">*</span></label>
                    <select class="form-control" name="state_id" id="delivery_area_state_id" required onchange="showCityByStateId('delivery_area_state_id','delivery_area_city_id');">
                        <option value="">{{__('lang.admin_select_state')}}</option>
                        @foreach($state as $eachstate)
                        <option value="{{$eachstate->id}}">{{$eachstate->state_name}}</option>
                        @endforeach
                    </select>
                    </div>
                </div>
                
                <div class="col-sm-12">
                    <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_city_name')}} <span class="required">*</span></label>
                    <select class="form-control delivery_area_city_id" name="city_id" id="delivery_area_city_id" required>
                    </select>
                    </div>
                </div>

                <div class="mb-1">
                    <label class="form-label" for="location_name">{{__('lang.admin_location_name')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="" placeholder="{{__('lang.admin_location_name')}}" aria-label="{{__('lang.admin_location_name')}}" name="location_name" autocomplete="off" required />
                </div>
                
                <div class="mb-1">
                    <label class="form-label" for="zip_code">{{__('lang.admin_zip_code')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="zip_code" placeholder="{{__('lang.admin_zip_code')}}" aria-label="{{__('lang.admin_zip_code')}}" name="zip_code" required/>
                </div>
                
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
<script type="text/javascript">
    setTimeout(function(){
        googleAutoComplete(); 
    },1000);
</script>
@endsection