@extends('layouts.app')
@section('content')

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_delivery_areas')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/delivery_areas*') ? 'active' : '' }}"><a href="{!! route('delivery_areas.index') !!}">{{__('lang.admin_delivery_area_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_delivery_area_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($data, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['delivery_areas.update', $data->id]]) !!}
                                @csrf
                                <div class="row">
                                    
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                        <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_state_name')}} <span class="required">*</span></label>
                                        <select class="form-control" name="state_id" id="delivery_area_state_id" required onchange="showCityByStateId('delivery_area_state_id','delivery_area_city_id');">
                                            <option value="">{{__('lang.admin_select_state')}}</option>
                                            @foreach($state as $eachstate)
                                            <option value="{{$eachstate->id}}"  @if($eachstate->id == $data->state_id) selected @endif>{{$eachstate->state_name}}</option>
                                            @endforeach
                                        </select>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                        <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_city_name')}} <span class="required">*</span></label>
                                        <select class="form-control delivery_area_city_id" name="city_id" id="delivery_area_city_id" required>
                                            @foreach($city as $eachcity)
                                                <option value="{{$eachcity->id}}" @if($eachcity->id == $data->city_id) selected @endif>{{$eachcity->city_name}}</option>
                                            @endforeach
                                        </select>
                                        </div>
                                    </div>
                
                
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_location_name')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_location_name')}}" value="{{$data->location_name}}" name="location_name" id="" required/>
                                        </div>
                                    </div>

                                    <input type="hidden" name="country" id="country" value="<?php echo (isset($data->country))?$data->country:'' ?>">
                                    <input type="hidden" name="city" id="city" value="<?php echo (isset($data->city))?$data->city:'' ?>">
                                    <input type="hidden" name="region" id="region" value="<?php echo (isset($data->region))?$data->region:'' ?>">
                                    <input type="hidden" id="latitude" name="latitude" value="<?php echo (isset($data->latitude))?$data->latitude:'' ?>"/>
                                    <input type="hidden" id="longitude" name="longitude" value="<?php echo (isset($data->longitude))?$data->longitude:'' ?>"/>

                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="zip_code">{{__('lang.admin_zip_code')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_zip_code')}}" value="{{$data->zip_code}}" name="zip_code" id="zip_code" required/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($data->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($data->status == 0) selected  @endif>{{__('lang.admin_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('delivery_areas.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>

        </div>
    </div>
</div>
<script type="text/javascript">
    setTimeout(function(){
        googleAutoComplete(); 
    },1000);
</script>
@endsection