<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_currencies_list')}}</h4>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_name')}}</th>
                                <th>{{__('lang.admin_currencies_symbol')}}</th>
                                <th>{{__('lang.admin_currencies_code')}}</th>
                                <th>{{__('lang.admin_currencies_decimal_digits')}}</th>
                                <!-- @can('update-currencies-status')
                                <th>{{__('lang.admin_status')}}</th>
                                @endcan -->
                                 <th>{{__('lang.admin_is_default')}}</th> 
                                @canany(['delete-currencies','update-currencies'])
                                <th>{{__('lang.admin_table_action')}}</th>
                                @endcanany
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td>{{$res->name}}</td>
                                <td>{{$res->symbol}}</td>
                                <td>{{$res->code}}</td>
                                <td>{{$res->decimal_digits}}</td>
                                <!-- @can('update-currencies-status')
                                <td>
                                    @if($res->status == 1)
                                        <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span>
                                    @else
                                        <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span>
                                    @endif
                                </td>
                                @endcan -->
                                 <td>
                                    @if($res->is_default == 1)
                                        <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_yes')}}</span>
                                    @else
                                        <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_no')}}</span>
                                    @endif
                                </td> 
                                @canany(['delete-currencies','update-currencies'])
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @can('update-currencies')
                                            <a class="dropdown-item" href="{{ route('currencies.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            @endcan
                                            @can('delete-currencies')
                                            <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('currency' , {{ $res->id }})">
                                                <i data-feather="trash" class="me-50"></i>
                                                <span>{{__('lang.admin_button_delete')}}</span>
                                               </a>
                                            @endcan
                                        </div>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="6" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>