@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_currency')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_currencies_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            @can('add-currencies')
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_currencies_add')}}</span>
                    </button>
                </div>
            </div>
            @endcan
            @include('currencies.table')
        </div>
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('currencies.store') !!}" enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_currencies_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-name">{{__('lang.admin_name')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="{{__('lang.admin_name')}}" aria-label="{{__('lang.admin_name')}}" name="name" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-symbol">{{__('lang.admin_currencies_symbol')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-symbol" id="basic-icon-default-symbol" placeholder="{{__('lang.admin_currencies_symbol')}}" aria-label="{{__('lang.admin_currencies_symbol')}}" name="symbol" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-code">{{__('lang.admin_currencies_code')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-code" id="basic-icon-default-code" placeholder="{{__('lang.admin_currencies_code')}}" aria-label="{{__('lang.admin_currencies_code')}}" name="code" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-decimal_digits">{{__('lang.admin_currencies_decimal_digits')}} <span class="required">*</span></label>
                    <input type="number" class="form-control dt-full-decimal_digits" id="basic-icon-default-decimal_digits" placeholder="{{__('lang.admin_currencies_decimal_digits')}}" aria-label="{{__('lang.admin_currencies_decimal_digits')}}" name="decimal_digits" required />
                </div>

                 <div class="form-check me-3 me-lg-5 mt-2 mb-1">
                  <input name="is_default" class="form-check-input" type="checkbox" data-permission="currencies" value="1">
                  <label class="form-check-label" for="currencies">{{__('lang.admin_is_default_currencies')}}</label>
                </div> 

                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
@endsection