@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_currency')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item"><a href="{!! route('currencies.index') !!}">{{__('lang.admin_currencies_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_currencies_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($data, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['currencies.update', $data->id]]) !!}
                                @csrf
                                <!-- timeslot edit form start -->
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="name">{{__('lang.admin_name')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_name')}}" value="{{$data->name}}" name="name" id="name" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="symbol">{{__('lang.admin_currencies_symbol')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_currencies_symbol')}}" value="{{$data->symbol}}" name="symbol" id="symbol" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="code">{{__('lang.admin_currencies_code')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_currencies_code')}}" value="{{$data->code}}" name="code" id="code" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="decimal_digits">{{__('lang.admin_currencies_decimal_digits')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_currencies_decimal_digits')}}" value="{{$data->decimal_digits}}" name="decimal_digits" id="decimal_digits" required />
                                        </div>
                                    </div>

                                     <div class="form-check me-3 mt-2 col-md-4" style="margin-right: 9rem !important;">
                                        <input value="{{ $data->is_default }}" {{ $data->is_default == '1' ? 'checked' : '' }} name="is_default" class="form-check-input" type="checkbox" data-permission="currencies"/>
                                        <label class="form-check-label" for="currencies">{{ __('lang.admin_is_default_currencies') }}</label>
                                    </div> 

                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('currencies.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- coupons edit ends -->

        </div>
    </div>
</div>
<!-- END: Content-->
@endsection