<div class="content-body">
     <!-- Striped rows start -->
     <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_coupon_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($coupons->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $coupons->firstItem() }}-{{ $coupons->lastItem() }} {{__('lang.admin_of')}} {{ $coupons->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_image')}}</th>
                                <th>{{__('lang.admin_coupon_code')}}</th>
                                <th>{{__('lang.admin_type')}}</th>
                                <th>{{__('lang.admin_coupon_value')}}</th>
                                <th>{{__('lang.admin_coupon_minvalue')}}</th>
                                <th>{{__('lang.admin_start_date')}}</th>
                                <th>{{__('lang.admin_end_date')}}</th>
                                @can('update-coupon-status')
                                <th>{{__('lang.admin_status')}}</th>
                                @endcan

                                @canany(['delete-coupon','update-coupon','coupon-translation'])
                                <th>{{__('lang.admin_table_action')}}</th>
                                @endcanany
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($coupons) > 0)
                            @foreach($coupons as $res)
                            <tr>
                                <td aria-colindex="2" role="cell" class=""><span class="b-avatar mr-1 badge-secondary rounded-circle"><span class="b-avatar-img">
                                    @if($res->image)
                                    <img src="{{asset('/app-assets/images/coupons/'.$res->image)}}" width="100px" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';">
                                    @else
                                    <img src="{{asset('/app-assets/images/no-image.png')}}">
                                    @endif
                                </span></span></td>
                                <td>{{ isset($res->coupon_name)?$res->coupon_name:'--' }}</td>
                                <td>{{ isset($res->type)?$res->type:'--' }}</td>
                                <td>
                                    {{($res->type=='Fixed')?\Helpers::currency($res->value):$res->value.'%' }}
                                </td>
                                <td>{{ isset($res->minimum_order_value)?\Helpers::currency($res->minimum_order_value):'--' }}</td>
                                <td>{{$res->start_date}}</td>
                                <td>{{$res->end_date}}</td>

                                @can('update-coupon-status')
                                <td>
                                    @if($res->end_date < date('Y-m-d'))
                                        <span class="badge rounded-pill badge-light-danger me-1">Expired</span>
                                    @else
                                        @if($res->status == 1)
                                            <a href="{{ url('admin/change-coupon-status/'.$res->id) }}">
                                                <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span></a>
                                        @else
                                            <a href="{{ url('admin/change-coupon-status/'.$res->id) }}">
                                                <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span></a>
                                        @endif
                                    @endif
                                </td>
                                @endcan

                                @canany(['delete-coupon','update-coupon','coupon-translation'])
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @can('update-coupon')
                                            <a class="dropdown-item" href="{{ route('coupons.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            @endcan
                                            @can('coupon-translation')
                                            <a class="dropdown-item" href="{{ url('admin/coupons/translation/'.$res->id) }}">
                                                <i data-feather="type" class="me-50"></i>
                                                <span>{{__('lang.admin_button_translation')}}</span>
                                            </a>
                                            @endcan
                                            @can('delete-coupon')
                                            <a class="dropdown-item" href="#" onclick="showDeleteConfirmation('coupon' , {{ $res->id }})">
                                            <i data-feather="trash" class="me-50"></i>
                                            <span>{{__('lang.admin_button_delete')}}</span>
                                            </a>
                                            @endcan
                                        </div>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="9" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                    <div class="pagination" style="float: right;">
                        {{$coupons->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>