@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}" />

<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_coupon')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_coupon_list')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            @can('add-coupon')
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_coupon_add')}}</span>
                    </button>
                </div>
            </div>
            @endcan
        </div>

        <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
            <div class="dt-action-buttons text-end">
                <form id="formData" method="get">
                    <div class="row">
                        <div class="col-md-3">
                            <input type="text" name="search" class="form-control" placeholder="{{__('lang.admin_seach_by_name')}}" id="search" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                        </div>

                        <div class="col-md-3">
                            <select class="form-select" name="type" id="type" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_type')}}</option>
                                @foreach($filter['type'] as $value => $sts)
                                <option value="{{ $value }}" @if(isset($_GET['type']) && $_GET['type'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                            @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <select class="form-select" name="status" id="status" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_status')}}</option>
                                @foreach($filter['status'] as $value => $sts)
                                <option value="{{ $value }}" @if(isset($_GET['status']) && $_GET['status'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                            @endforeach
                            </select>
                        </div>

                        <div class="col-md-3" style="text-align: left;">
                            <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                            <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        @include('coupons.table')
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('coupons.store') !!}" enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_coupon_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                    <div class="col-12 d-flex mt-1 px-0">
                        <label class="btn btn-primary me-75 mb-0" for="change-picture">
                            <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                            <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                            <span class="d-block d-sm-none">
                                <i class="me-0" data-feather="edit"></i>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_coupon_name')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="{{__('lang.admin_coupon_name')}}" aria-label="{{__('lang.admin_coupon_name')}}" name="coupon_name" required/>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="coupon_type">{{__('lang.admin_type')}} <span class="required">*</span></label>
                    <select id="coupon-type" class="form-select" name="type" required>
                        <option value="Fixed">{{__('lang.admin_coupon_type_fixed')}}</option>
                        <option value="Percent">{{__('lang.admin_coupon_type_percent')}}</option>
                    </select>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-discount_price">{{__('lang.admin_coupon_value')}} <span class="required">*</span></label>
                    <input type="text" id="basic-icon-default-discount_price" class="form-control dt-discount_price" placeholder="{{__('lang.admin_coupon_value')}}" aria-label="{{__('lang.admin_coupon_value')}}" name="value"  required/>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-stock">{{__('lang.admin_coupon_minvalue')}} <span class="required">*</span></label>
                    <input type="text" id="basic-icon-default-stock" class="form-control dt-post" placeholder="{{__('lang.admin_coupon_minvalue')}}" aria-label="{{__('lang.admin_coupon_minvalue')}}" name="minimum_order_value"  required/>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="start_date">{{__('lang.admin_start_date')}} / {{__('lang.admin_end_date')}} <span class="required">*</span></label>
                    <input type="text" id="fp-default" class="form-control flatpickr-today-range" placeholder="YYYY-MM-DD" aria-label="{{__('lang.admin_start_date')}}" name="start_date" required/>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="description">{{__('lang.admin_details')}} <span class="required">*</span></label>
                    <textarea type="text" class="form-control" placeholder="{{__('lang.admin_details')}}" name="description" id="description"  required></textarea>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="status">{{__('lang.admin_status')}} <span class="required">*</span></label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="1">{{__('lang.admin_active')}}</option>
                        <option value="0">{{__('lang.admin_deactive')}}</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>

<!-- END: Content-->
@endsection