@extends('layouts.app')
@section('content')

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}" />

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_coupon')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/coupons*') ? 'active' : '' }}"><a href="{!! route('coupons.index') !!}">{{__('lang.admin_coupon_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_coupon_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <!-- users edit start -->
                                {!! Form::model($coupon, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['coupons.update', $coupon->id]]) !!}
                                @csrf
                                <div class="d-flex mb-2">
                                    @if($coupon->image!='')
                                    <img src="{{asset('app-assets/images/coupons/'.$coupon->image)}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';"/>
                                    @else
                                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    @endif
                                    <div class="mt-50">
                                    <h4>{{$coupon->coupon_name}}</h4>
                                        <div class="col-12 d-flex mt-1 px-0">
                                            <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                                <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                                                <span class="d-block d-sm-none">
                                                    <i class="me-0" data-feather="edit"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <!-- coupons edit ends -->
                                <!-- coupons edit form start -->
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_coupon_name')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_coupon_name')}}" value="{{$coupon->coupon_name}}" name="coupon_name" id="coupon_name"  required/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="name">{{__('lang.admin_type')}} <span class="required">*</span></label>
                                            <select name="type" id="type" class="form-select" required>
                                                <option value="Fixed" @if($coupon->type=='Fixed') selected @endif >{{__('lang.admin_coupon_type_fixed')}}</option>
                                                <option value="Percent" @if($coupon->type=='Percent') selected @endif>{{__('lang.admin_coupon_type_percent')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email">{{__('lang.admin_coupon_value')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_coupon_value')}}" value="{{$coupon->value}}" name="value" id="email" required/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="minimum_order_value">{{__('lang.admin_coupon_minvalue')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_coupon_minvalue')}}" value="{{$coupon->minimum_order_value}}" name="minimum_order_value" id="minimum_order_value" required/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="start_date">{{__('lang.admin_start_date')}} / {{__('lang.admin_end_date')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control flatpickr-today-range" placeholder="{{__('lang.admin_start_date')}}" value="{{$coupon->start_date}} to {{$coupon->end_date}}" name="start_date" id="start_date" required/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}} <span class="required">*</span></label>
                                            <select class="form-select" id="status" name="status" required>
                                                <option value="1" @if($coupon->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($coupon->status == 0) selected  @endif>{{__('lang.admin_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="mb-1">
                                            <label class="form-label" for="description">{{__('lang.admin_details')}} <span class="required">*</span></label>
                                            <textarea type="text" class="form-control" placeholder="{{__('lang.admin_details')}}" name="description" id="description" required/>{{$coupon->description}}</textarea>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('coupons.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                                <!-- coupons edit form ends -->
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- coupons edit ends -->

        </div>
    </div>
</div>

<script type="text/javascript">
    var basicPickr = $('.flatpickr-basic');
    basicPickr.flatpickr();
</script>
<!-- END: Content-->
@endsection