@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_contact_us')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_contact_us_list')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
            <div class="dt-action-buttons text-end">
                <form id="formData" method="get">
                    <div class="row">
                        <div class="form-group col-sm-5">
                            <input type="text" name="search" class="form-control" placeholder="{{__('lang.admin_search_by_name_email_phone')}}" id="search" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                        </div>

                        <div class="col-md-4">
                            <select class="form-select" name="status" id="status" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_status')}}</option>
                                @foreach($filter['status'] as $value => $sts)
                                <option value="{{ $sts }}" @if(isset($_GET['status']) && $_GET['status'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                            @endforeach
                            </select>
                        </div>

                        <div class="form-group col-sm-3" style="text-align: left;">
                            <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                            <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        
        @if(
            empty(setting('mail_driver')) ||
            empty(setting('mail_host')) ||
            empty(setting('mail_port')) ||
            empty(setting('mail_username')) || 
            empty(setting('mail_password')) || 
            empty(setting('mail_encrytion')) || 
            empty(setting('mail_from_address'))
        )
            <div class="alert alert-warning d-flex align-items-center" role="alert" style="padding: 15px;">
                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-info">
                    <circle cx="12" cy="12" r="10"></circle>
                    <line x1="12" y1="16" x2="12" y2="12"></line>
                    <line x1="12" y1="8" x2="12.01" y2="8"></line>
                </svg>
                <span style="margin-left: 5px;">
                {{ __('lang.admin_setup_mail_setting_to_use_contactus_reply_feature') }}
                </span>
            </div>
        @endif


        @include('contact_us.table')
    </div>
</div>
@endsection