@extends('layouts.site-app')
@section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.contact_title')}}</div>
</section>
<section class="contact-bg">
    <div class="container">
        <div class="contact-top">
            <div class="row">
                <div class="col-md-6">
                    <div class="loginform contactform">
                        @if(Session::has('message'))
                        <div class="alert alert-success" role="alert">
                          {{ Session::get('message') }}
                        </div>
                        @endif
                        @if(Session::has('error'))
                        <div class="alert alert-danger" role="alert">
                          {{ Session::get('error') }}
                        </div>
                        @endif
                        {!! Form::model(null, ['method' => 'POST', 'url' => ['contact-us']]) !!}
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <span><img src="{{asset('site-assets/images/user_wall.svg')}}"/></span>
                                    <input type="text" class="form-control" name="name" placeholder="{{__('lang.placeholder_your_name')}} *" required />
                                </div>
                                <div class="form-group col-md-12">
                                    <span><img src="{{asset('site-assets/images/mail.svg')}}"/></span>
                                    <input type="email" class="form-control" name="email" placeholder="{{__('lang.placeholder_email_address')}} *" required/>
                                </div>
                                <div class="form-group col-md-12">
                                    <span><img src="{{asset('site-assets/images/mobile0edit.svg')}}"/></span>
                                    <input type="text" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" class="form-control" name="mobile" maxlength="10"  placeholder="{{__('lang.placeholder_mobile_num')}} *" required/>
                                </div>
                                <div class="form-group col-md-12">
                                    <span><img src="{{asset('site-assets/images/note.png')}}"/ style="filter: contrast(0.5) brightness(1.5);"></span>
                                    <textarea class="form-control" name="message" id="message" placeholder="{{__('lang.placeholder_note')}} *" style="height: 115px; padding-top: 20px;" required></textarea>
                                </div>
                                <div class="form-group col-md-5">
                                    <button class="submit-btn text-uppercase mt-4">{{__('lang.send_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1"/></button>
                                </div>
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="getintouch-bg">
                        <h4>{{__('lang.contact_des_key')}}</h4>
                        <h6>{{__('lang.contact_description')}}</h6>
                        <ul>
                            <li>
                                <img src="{{asset('site-assets/images/mail.svg')}}"  />
                                <h4>{{setting('contact_email')}}</h4>
                                <p>{{__('lang.email')}}</p>
                            </li>
                            <li>
                                <img src="{{asset('site-assets/images/mobile0edit.svg')}}"  />
                                <h4>{{setting('contact_phone')}}</h4>
                                <p>{{__('lang.phone')}}</p>
                            </li>
                            <li>
                                <img src="{{asset('site-assets/images/map.svg')}}"  />
                                <h4>{{setting('contact_address')}}</h4>
                                <p>{{__('lang.address')}}</p>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="contactmap">
    <iframe class="contact_map_set"
        width="100%"
        height="500"
        style="border: 0;"
        allowfullscreen=""
        loading="lazy"
        src="https://www.google.com/maps?q={{ $settingsArray['google_address_latitude'] }},{{ $settingsArray['google_address_longitude'] }}&hl=es;z=14&output=embed">
    </iframe>
</div>
<footer class="footer">
    @include('partials.site.footer')
</footer>
<!-- END: Content-->
@endsection
