@extends('layouts.site-app')
@section('sitecontent')

<style>
span.select2-selection.select2-selection--single {
    height: 45px;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 45px !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    top: 11px !important;
}
</style>

<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.checkout_title')}}</div>
</section>
<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-11">
                @include('partials.site.alert')
                <div class="chooselocation selectlocation">
                    <span><img src="{{asset('site-assets/images/chooseloacation.png')}}"  /></span>
                    {{__('lang.select_location')}}
                </div>
                <div class="add-address">
                    <a href="javascript:;" onclick="showAddressForm()"><img src="{{asset('site-assets/images/plusico.png')}}" style="width: 30%;" /></a> <span onclick="showAddressForm()" style="cursor: pointer;">{{__('lang.add_address')}}</span>
                </div>
                <div class="addressformbg" id="addAddressForm" style="display: none">
                    <div class="row">
                        @if(setting('google_address_map_api_key') != '' && setting('is_enable_google_map_address') == 1)
                        <div class="col-lg-7">
                            <div class="map">
                                <div id="myMap" style="height:430px;width: 100%;position: relative;overflow: hidden;border: 1px solid #a5a5a5;border-radius: 5px;margin-bottom: 5px"></div>
                            </div>
                        </div>
                        @else
                        <div class="col-lg-4"></div>
                        @endif
                        
                        <div class="col-lg-5">
                            <div class="addressform">
                                {!! Form::model(null, ['id'=>'addressForm','method' => 'POST', 'url' => ['add-address']]) !!}
                                    @csrf
                                    @if(setting('google_address_map_api_key') != '' && setting('is_enable_google_map_address') == 1)
                                        <input type="hidden" name="location_name" id="location_name" value="">
                                        <input type="hidden" name="latitude" id="latitude" value="{{ setting('google_address_latitude') ?? '' }}">
                                        <input type="hidden" name="longitude" id="longitude" value="{{ setting('google_address_longitude') ?? '' }}">
                                        <input type="hidden" name="city" id="city">
                                        <input type="hidden" name="state" id="state">
                                        <input type="hidden" name="zipcode" id="zipcode">
                                        <input type="hidden" name="country" id="country">
                                        <div class="row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_detact_location')}}</label>
                                                <input type="text" class="form-control" name="google_address" id="google_address"    placeholder="{{__('lang.address_detact_location')}}"  onkeypress="return handleKeyPress(event)"/>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_type')}}</label>
                                                <div class="radio">
                                                    <input label="" type="radio" id="Home" name="type" value="{{__('lang.address_home')}}" checked />
                                                    <input label="" type="radio" id="Office" name="type" value="{{__('lang.address_office')}}" />
                                                    <input label="" type="radio" id="Mosque" name="type" value="{{__('lang.address_mosque')}}" />
                                                    <input label="" type="radio" id="other" name="type" value="{{__('lang.address_other')}}" />
                                                </div>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_title')}}</label>
                                                <input type="text" class="form-control" name="address" placeholder="{{__('lang.address_title')}}" />
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.placeholder_note')}}</label>
                                                <textarea class="form-control" name="note" id="note" style="height: 70px;" placeholder="{{__('lang.placeholder_note')}}" ></textarea>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <button class="save-btn text-uppercase float-right" id="addressFormBtn"  onclick="return false"  type="submit">{{__('lang.save_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1"/></button>
                                                <button type="button" onClick="hideAddressForm();" class="save-btn text-uppercase float-left" style="background: #af7ab3;">{{__('lang.cancel_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                            </div>
                                    </div>
                                    @else
                                        <div class="row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.zipcode')}}</label>
                                                <select onchange="showCityAndStateByZipcode('zipcode');" class="form-control" name="zipcode" id="zipcode" required>
                                                </select>
                                            </div>
                                            
                                            <div class="col-sm-12 hide zipcode_related_inp">
                                                <div class="mb-1">
                                                    <label class="form-label" for="address_state_name">{{__('lang.admin_state_name')}} <span class="required">*</span></label>
                                                    <input class="form-control address_state_name" id="address_state_name" disabled>
                                                </div>
                                            </div>
                                            
                                            <div class="col-sm-12 hide zipcode_related_inp">
                                                <div class="mb-1">
                                                    <label class="form-label" for="address_city_name">{{__('lang.admin_city_name')}} <span class="required">*</span></label>
                                                    <input class="form-control address_city_name" id="address_city_name" disabled>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_type')}}</label>
                                                <div class="radio">
                                                    <input label="" type="radio" id="Home" name="type" value="{{__('lang.address_home')}}" checked />
                                                    <input label="" type="radio" id="Office" name="type" value="{{__('lang.address_office')}}" />
                                                    <input label="" type="radio" id="Mosque" name="type" value="{{__('lang.address_mosque')}}" />
                                                    <input label="" type="radio" id="other" name="type" value="{{__('lang.address_other')}}" />
                                                </div>
                                            </div>
                                            
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.address_title')}}</label>
                                                <input type="text" class="form-control" name="address" placeholder="{{__('lang.address_title')}}" />
                                            </div>
                                            
                                            <div class="form-group col-md-12">
                                                <label>{{__('lang.placeholder_note')}}</label>
                                                <textarea class="form-control" name="note" id="note" style="height: 70px;" placeholder="{{__('lang.placeholder_note')}}" ></textarea>
                                            </div>
                                            
                                            <div class="form-group col-md-12">
                                                <button class="save-btn text-uppercase float-right" id="addressFormBtn"  onclick="return false"  type="submit">{{__('lang.save_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1"/></button>
                                                <button type="button" onClick="hideAddressForm();" class="save-btn text-uppercase float-left" style="background: #af7ab3;">{{__('lang.cancel_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                            </div>
                                            
                                        </div>
                                    @endif
                                {!! Form::close() !!}
                            </div>
                        </div>
                        
                        @if(setting('google_address_map_api_key') != '' && setting('is_enable_google_map_address') == 1)
                        @else
                        <div class="col-lg-4"></div>
                        @endif
                        
                    </div>
                </div>
                {!! Form::model(null, ['id'=>'placeOrderForm','method' => 'GET', 'url' => ['place-order']]) !!}
                    @csrf
                    <div class="select-address">
                        @if(count($data)>0)
                            @foreach($data as $row)
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input" name="delivery_address_id" value="{{$row->id}}" id="customRadio_{{$row->id}}" name="selectaddress">
                                    <label class="custom-control-label" for="customRadio_{{$row->id}}"> <span>{{$row->type}} @if($row->location_name!='')({{$row->location_name}})@endif</span> @if($row->address!='') {{$row->address}}, @endif {{$row->zipcode}},  @if($row->city!='') {{$row->city}}, @endif  @if($row->state!='') {{$row->state}}, @endif</label>
                                    <a onclick="return confirm('Are you sure you want to delete this address?');" class="checkouts" href="{{url('/delete-address')}}/{{$row->id}}"><img src="images/icon-trash.svg" alt=""></a>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="nextbtn">
                        <button class="save-btn text-uppercase float-left full-width-btn" id="placeOrderFormBtn" type="submit">{{__('lang.next_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1"/></button>
                    </div>
                {!! Form::close() !!}
            </div>

        </div>
    </div>
    <div class="modal" id="profileModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="profileModalLabel">You can't continue with checkout process untill complete your profile details. </h5>
                </div>
                <!-- Modal body -->
                <div class="modal-body">
                    <div class="loginform contactform">
                        @if(Session::has('message') || $errors->any())
                            <div class="alert {{ Session::has('message') ? 'alert-success' : 'alert-danger' }}" role="alert">
                                @if(Session::has('message'))
                                    {{ Session::get('message') }}
                                @endif
                                @if ($errors->any())
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        @endif
                        {!! Form::model(null, ['method' => 'POST', 'url' => url('/save-login-user-details')]) !!}
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <span><img src="{{asset('site-assets/images/user_wall.svg')}}"/></span>
                                    <input type="text" class="form-control" name="username" placeholder="{{__('lang.placeholder_your_name')}} *" required  value="{{ $user->name }}"/>
                                </div>
                                <div class="form-group col-md-12">
                                    <span><img src="{{asset('site-assets/images/mail.svg')}}"/></span>
                                    <input type="email" class="form-control" name="email" placeholder="{{__('lang.placeholder_email_address')}} *" required value="{{ $user->email }}"/>
                                </div>
                                <div class="form-group col-md-5">
                                    <button class="submit-btn text-uppercase mt-4">{{__('lang.save_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1"/></button>
                                </div>
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<footer class="footer">
    @include('partials.site.footer')
</footer>

<script src="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
    setTimeout(function(){
        getLocation();
    },1500);
</script>
<script>
     // Check if there are validation errors and the profile modal should be open
    @if ($errors->any() && session('profileModalOpen'))
        $('#profileModal').modal('show');
    @endif
    window.onload = function() {
        var url= "{{ url('/verify-login-user-details') }}";
        $.ajax({
            url:  url,
            type: 'POST',
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
            },
            success: function(response) {
                if(response.status==false && response.redirect==false){
                    $('#profileModal').modal('show');
                }else if(response.status==true){
                    $('#profileModal').modal('hide');
                }else{
                    $('#profileModal').modal('hide');
                }
            },
            error: function(xhr, status, error) {
                //alert('An error occurred: ' + error);
                Swal.fire({
                    title: 'Error',
                    text:  error,
                    confirmButtonText: "{{ __('lang.ok') }}",
                }).then((result) => {
                    if (result.isConfirmed) {
                       // $('#addressForm')[0].reset();
                        $('#profileModal').modal('show');
                    }
                });
            }
        });
    };

</script>
<script>
    $(document).ready(function () {
        // Prevent form submission on Enter key
        $('#addressForm').on('keypress', function (e) {
            if (e.which === 13) {
                e.preventDefault();
            }
        });

        // Fetch delivery areas zip codes as an array and ensure all are strings
        const deliveryZipCodes = {!! json_encode(App\Models\DeliveryAreas::where('status', 1)->pluck('zip_code')->toArray()) !!}.map(String);

        // Debugging: Log the deliveryZipCodes array
        console.log("Delivery Zip Codes:", deliveryZipCodes);

        // Handle the form submission
        $('#addressFormBtn').on('click', function (e) {
            e.preventDefault(); // Prevent the default form submission

            const zipcode = $('#zipcode').val()?.trim(); // Get and sanitize the zip code
            console.log("User Zip Code:", zipcode); // Debugging

            if (zipcode && deliveryZipCodes.includes(zipcode)) {
                // Submit the form if the zip code matches
                $('#addressForm').submit();
            } else {
                // Show an alert if the zip code is invalid
                Swal.fire({
                    title: "{{ __('lang.invalid_zipcode') }}",
                    text: "{{ __('lang.entered_zipcode_is_not_within_our_delivery_range') }}",
                    confirmButtonText: "{{ __('lang.ok') }}",
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#addressForm')[0].reset(); // Reset the form after confirmation
                    }
                });
            }
        });
    });

    // Optional: Functions to show/hide additional address forms
    function showAddressForm() {
        $('#addAddressForm').show();
    }

    function hideAddressForm() {
        $('#addAddressForm').hide();
    }
    
    
    function showCityAndStateByZipcode(zipcode) {
        var zipcode_value = $('#' + zipcode).val();
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        $.ajax({
            url: base_url + '/get-city-state-by-zipcode',
            type: 'POST',
            data: {
                'zip_code': zipcode_value
            },
            dataType: 'json',
            success: function(response) {
                if (response.status) {
                    if (zipcode_value !== '') {
                        $('.zipcode_related_inp').removeClass('hide');
                        $(".address_state_name").val(response.state);
                        $(".address_city_name").val(response.city);
                    } else {
                        $('.zipcode_related_inp').addClass('hide');
                        $(".address_state_name").val('');
                        $(".address_city_name").val('');
                    }
                } else {
                    myToastr(response.message, 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error: ', error);
                myToastr("Something went wrong. Please try again.", 'error');
            }
        });
    }
</script>


<!-- Select2 CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />

<!-- Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<script>
    $(document).ready(function() {
        $('#zipcode').select2({
            placeholder: "{{ __('lang.select_zipcode') }}",
            allowClear: true,
            width: '100%',
            minimumInputLength: 2,
            language: {
                inputTooShort: function() {
                    return "{{ __('lang.select_zipcode_type_length_msg') }}";
                },
                noResults: function() {
                    return "{{ __('lang.no_area_found_on_typed_zipcode') }}";
                }
            },
            ajax: {
                url: '{{ route("getZipCodes") }}', // Route for fetching zip codes
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        search: params.term // User's search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item) {
                            return {
                                id: item.zip_code,
                                text: item.zip_code + ' (' + item.location_name + ')'
                            };
                        })
                    };
                },
                cache: true
            }
        });
    });
</script>
<!-- END: Content-->
@endsection