@extends('layouts.site-app')
@section('sitecontent')

<style type="text/css">
    div#swal2-html-container {
        line-height: 25px;
        white-space: pre-line;
    }
</style>

<?php
$disabledWeekDays = array();
$highlightedDates = array();
foreach ($holdaysDate as $rows) {
    $temp = array(
        'start' => date("Y-m-d",strtotime($rows->start_date)),
        'end' => date("Y-m-d",strtotime($rows->end_date))
    );
    array_push($disabledWeekDays, $temp);

    $i = 0;
    $startDate = $rows->start_date;
    do{
        $currentDate = date("Y-m-d",strtotime($startDate.' + '.$i.' day'));
        $tempAr = array(
            'date' => $currentDate,
            'highlight' => 'red',
            'markCssClass' => 'square-mark'
        );
        array_push($highlightedDates, $tempAr);
        $i++;
    }while(strtotime($currentDate)<strtotime($rows->end_date));
}
?>
<script>
    var  mobiscrollObj = [];
    var weekDays = '<?php echo json_encode($disabledWeekDays); ?>';
    weekDays = JSON.parse(weekDays);
    var highlightedDates = '<?php echo json_encode($highlightedDates); ?>';
    highlightedDates = JSON.parse(highlightedDates);
    var invalidObj = weekDays;
</script>

<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">
        @if(count($data)>0)
            <p class="mt-3">{{__('lang.cart_title')}}</p>
        @else
            <p class="mt-3">{{__('lang.not_items_in_cart')}}</p> 
        @endif
    </div>
</section>
<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            @if(count($data)>0)
                @if(Session::has('message'))
                    <div class="col-lg-11">
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ Session::get('message') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    </div>
                @endif

                @if(Session::has('error'))
                    <div class="col-lg-11">
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ Session::get('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    </div>
                @endif
            @endif

            <div class="col-lg-11">
                @if(count($data)>0)
                    {!! Form::model(null, ['method' => 'POST', 'url' => ['cart-checkout']]) !!}
                        @csrf
                        @foreach($data as $row)
                            @if($row->product)
                                <div class="inforow">
                                    <input type="hidden" name="cart_id[]" value="{{$row->id}}">
                                    <input type="hidden" id="product_min_qty_{{$row->id}}" value="{{($row->product->minimum_order_quantity>0)?$row->product->minimum_order_quantity:1}}">
                                    <div class="row">
                                        <div class="col-md-2 col-sm-2 col-2">
                                            <span class="productimg"><img src="{{asset('app-assets/images/products')}}/{{$row->product->image}}" alt="{{$row->name}}" /></span>
                                        </div>
                                        <div class="col-md-3 col-sm-3 col-2">
                                            <span data-fullname="{{$row->product->name}}" class="productname" style="width:100%;margin-top:5px">{{$row->product->name}}</span>
                                        </div>
                                        <div class="col-md-2 col-sm-2 col-2">
                                             <span class="productname product_price" style="width:100%;margin-top:5px;font-weight:600">{{\Helpers::currency($row->total_delivery_amount)}}</span>
                                        </div>
                                        <div class="col-md-5 col-sm-5 col-4">
                                            <span class="productnumber" style="width:100%;margin-top:5px">
                                                <button data-action="decrement" class="decrbtn" type="button">
                                                    <span class="m-auto text-2xl font-thin">−</span>
                                                </button>
                                                <input type="number" name="quantity[]" value="{{$row->quantity}}" id="{{$row->id}}" readonly />
                                                <button data-action="increment" class="decrbtn" type="button">
                                                    <span class="m-auto text-2xl font-thin">+</span>
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="editdeletebtns">
                                        <a href="{{url('delete-cart-item')}}/{{$row->id}}" title="{{__('lang.delete_cart_item')}}"><img src="{{asset('site-assets/images/Delete.svg')}}"  /></a>
                                        <a href="javascript:;" onclick="enableCalculation();" data-toggle="collapse" data-target="#tab_{{$row->id}}" title="{{__('lang.edit_cart')}}"><img src="{{asset('site-assets/images/edit.svg')}}"  /></a>
                                    </div>
                                </div>
                                <div class="calenderbg-outer collapse" id="tab_{{$row->id}}">
                                    <div class="calenderbg addressform calenderradio">
                                        <div class="calenderradio02 radio row">
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="once_{{$row->id}}" onclick="selectFrequency('once','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Once" @if($row->order_frequency=='once') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="daily_{{$row->id}}" onclick="selectFrequency('daily','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Daily"  @if($row->order_frequency=='daily') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="weekly_{{$row->id}}" onclick="selectFrequency('weekly','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Weekly"  @if($row->order_frequency=='weekly') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="monthly_{{$row->id}}" onclick="selectFrequency('monthly','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Monthly"  @if($row->order_frequency=='monthly') checked @endif/></span>
                                            <span class="col-4 p-1"><input type="radio" class="w-100" id="alternative_{{$row->id}}" onclick="selectFrequency('alternative','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Alternative"  @if($row->order_frequency=='alternative') checked @endif/></span>
                                        </div>
                                        <div class="weeklydays @if($row->order_frequency!='weekly') hide @endif days_option_{{$row->id}}">
                                            <h3>{{__('lang.select_days_for_delivery')}}</h3>
                                            <div class="radio">
                                                <?php
                                                $days = explode(",",$row->days);
                                                ?>
                                                <input type="checkbox" id="days_sun_{{$row->id}}" name="days_{{$row->id}}[sun]" value="S"  @if(in_array(0,$days)) checked @endif/>
                                                <input type="checkbox" id="days_mon_{{$row->id}}" name="days_{{$row->id}}[mon]" value="M"  @if(in_array(1,$days)) checked @endif/>
                                                <input type="checkbox" id="days_tue_{{$row->id}}" name="days_{{$row->id}}[tue]" value="T"  @if(in_array(2,$days)) checked @endif/>
                                                <input type="checkbox" id="days_wed_{{$row->id}}" name="days_{{$row->id}}[wed]" value="W"  @if(in_array(3,$days)) checked @endif/>
                                                <input type="checkbox" id="days_thu_{{$row->id}}" name="days_{{$row->id}}[thu]" value="T"  @if(in_array(4,$days)) checked @endif/>
                                                <input type="checkbox" id="days_fri_{{$row->id}}" name="days_{{$row->id}}[fri]" value="F"  @if(in_array(5,$days)) checked @endif/>
                                                <input type="checkbox" id="days_sat_{{$row->id}}" name="days_{{$row->id}}[sat]" value="S"  @if(in_array(6,$days)) checked @endif/>
                                            </div>
                                        </div>
                                        <div class="quickselection @if($row->order_frequency!='weekly') hide @endif days_option_{{$row->id}}">
                                            <div class="radio">
                                                <span>{{__('lang.quick_selection')}}</span>
                                                <input type="radio" id="weekday_{{$row->id}}" name="quick[]" onclick="selectQuickSelection('WEEKDAYS','{{$row->id}}');" value="{{__('lang.weekdays')}}" />
                                                <input type="radio" id="weekends_{{$row->id}}" name="quick[]" onclick="selectQuickSelection('WEEKENDS','{{$row->id}}');" value="{{__('lang.weekend')}}" />
                                            </div>
                                        </div>
                                        <div class="calenderbox">
                                            <h3>{{__('lang.select_deliver_date')}}</h3>
                                            <?php
                                            $date = $row->start_date. ' - '.$row->end_date;
                                            if($row->order_frequency=='once'){
                                                $date = $row->start_date;
                                            }
                                            if($row->order_frequency=='monthly'){
                                                $date = $row->delivery_dates;
                                            }
                                            ?>
                                            <input type="hidden" class="demo-multi-day" id="delivery_dates_{{$row->id}}" name="delivery_dates[]" value="{{$date}}" required>
                                        </div>
                                    </div>
                                    <?php if($row->order_frequency=='once'){ ?>
                                        <script type="text/javascript">
                                            var currentDate = new Date();
                                            currentDate.setDate(currentDate.getDate() + nearest_delivery_date);
                                            mobiscrollObj[<?php echo $row->id; ?>] = mobiscroll.setOptions({
                                                locale: mobiscroll.localeEn,
                                            });
                                            $("#delivery_dates_<?php echo $row->id; ?>")
                                            .mobiscroll()
                                            .datepicker({
                                                controls: ["calendar"],
                                                invalid: invalidObj,
                                                colors : highlightedDates,
                                                display: "inline",
                                                min: currentDate
                                            });
                                        </script>
                                    <?php }else if($row->order_frequency=='monthly'){ ?>
                                        <script type="text/javascript">
                                            var currentDate = new Date();
                                            currentDate.setDate(currentDate.getDate() + nearest_delivery_date);
                                            mobiscrollObj[<?php echo $row->id; ?>] = mobiscroll.setOptions({
                                                locale: mobiscroll.localeEn,
                                            });
                                            $("#delivery_dates_<?php echo $row->id; ?>")
                                            .mobiscroll()
                                            .datepicker({
                                                controls: ["calendar"],
                                                invalid: invalidObj,
                                                marked : highlightedDates,
                                                display: "inline",
                                                selectMultiple: true,
                                                min: currentDate
                                            });
                                        </script>
                                    <?php }else{ ?>
                                        <script type="text/javascript">
                                            var currentDate = new Date();
                                            currentDate.setDate(currentDate.getDate() + nearest_delivery_date);
                                            mobiscrollObj[<?php echo $row->id; ?>] = mobiscroll.setOptions({
                                                locale: mobiscroll.localeEn,
                                            });
                                            $("#delivery_dates_<?php echo $row->id; ?>")
                                            .mobiscroll()
                                            .datepicker({
                                                controls: ["calendar"],
                                                display: "inline",
                                                select:'range',
                                                marked : highlightedDates,
                                                showRangeLabels: false,
                                                selectMultiple: true,
                                                min: currentDate
                                            });
                                        </script>
                                    <?php } ?>
                                </div>
                            @endif
                        @endforeach
                        <div class="cart-total-box calculation">
                            <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                            <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                            <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                            <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} <br><a href="#" data-toggle="modal" data-target="#coupon">{{__('lang.change_coupon_btn')}}</a> @else <a href="#" data-toggle="modal" data-target="#coupon">{{__('lang.apply_coupon_btn')}}</a>  @endif </p>
                            <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>
                            <p><button class="submit-btn mt-3 full-width-btn" id="cart_submit" type="submit" name="submit_button" value="next">{{__('lang.next_btn')}}<img src="{{asset('site-assets/images/arrowright.png')}}"/></button></p>
                        </div>
                        <div class="cart-total-box hide calculate">
                            <p><button class="submit-btn mt-3 full-width-btn" type="submit" name="submit_button" value="recalculate">{{__('lang.re_calculate_btn')}} <img src="{{asset('site-assets/images/arrowright.png')}}"/></button></p>
                        </div>
                    {!! Form::close() !!}
                @else
                    <div class="alert alert-danger" role="alert">
                      {{__('lang.add_items_cart_now')}}
                    </div>
                    <p style="text-align: center;">
                        <?php
                        $url = url('/#populargoods');
                        ?>
                        <button class="col-lg-3 submit-btn mt-3 full-width-btn cart_btn" type="button" onclick="window.location.href='{{$url}}'">{{__('lang.navigation_home')}}</button>
                    </p>
                @endif
            </div>
        </div>
    </div>
</section>
@include('partials.site.coupon')
<footer class="footer">
    @include('partials.site.footer')
</footer>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        // Attach event handler to the button
        let url= "{{ url('/check-update-cart') }}";
        checkUserExistingCart(url);

        function checkUserExistingCart(url) {
            $.ajax({
                url: url,
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                        if (response.status === 'success') {
                            if (response.updatedItems.length > 0) {
                                let message = "Your cart has been updated with the latest prices and quantities:\n";
                                response.updatedItems.forEach(item => {
                                    message += `\nProduct: ${item.product_name}\n`;
                                    message += `Old Price: ${item.old_price}\nNew Price: ${item.new_price}\n`;
                                    message += `Old Quantity: ${item.old_quantity}\nNew Quantity: ${item.new_quantity}\n`;
                                });
                                Swal.fire({
                                    title: 'Cart Updated Info',
                                    text: message,
                                    confirmButtonText: 'Update your Cart'
                                }).then(() => {
                                    location.reload();
                                });
                            }
                        } else {
                            Swal.fire({
                                text: 'Something went wrong while checking your cart.',
                                icon: 'error',
                                confirmButtonText: 'Retry'
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            title: 'Error',
                            text: 'Failed to check your cart. Please try again later.',
                            confirmButtonText: 'Retry'
                        });
                    }
                });
            }
        });
</script>

<script>
    function truncateText() {
        let productName = document.querySelector(".productname");
        let fullText = productName.getAttribute("data-fullname").trim(); // Get full text
        let limit = window.innerWidth <= 768 ? 10 : 30; // 10 characters for mobile, 30 for web

        if (fullText.length > limit) {
            productName.innerText = fullText.substring(0, limit) + "..."; // Trim and add "..."
        } else {
            productName.innerText = fullText; // Show full text if within limit
        }
    }

    window.addEventListener("load", truncateText);
    window.addEventListener("resize", truncateText);
</script>

@endsection
