@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-body">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_banners')}}</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{__('lang.admin_banner_list')}}
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                @can('add-banner')
                <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                    <div class="mb-1 breadcrumb-right">
                        <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                            <i data-feather="plus" class="me-25"></i>
                            <span>{{__('lang.admin_banner_add')}}</span>
                        </button>
                    </div>
                </div>
                @endcan
            </div>

        <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
            <div class="dt-action-buttons text-end">
                <form id="formData" method="get">
                    <div class="row">
                        <div class="col-md-3">
                            <input type="text" name="search" class="form-control" placeholder="{{__('lang.admin_search_by_name')}}" id="search" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                        </div>

                         <div class="col-md-3">
                            <select class="form-select" name="type" id="type" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_type')}}</option>
                                @foreach($filter['type'] as $sts)
                                <option value="{{ $sts }}" @if(isset($_GET['type']) && $_GET['type'] == $sts) selected @endif>{{ ucfirst($sts) }}</option>
                            @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <select class="form-select" name="status" id="status" style="width: -webkit-fill-available">
                                <option value="">{{__('lang.admin_status')}}</option>
                                @foreach($filter['status'] as $value => $sts)
                                <option value="{{ $value }}" @if(isset($_GET['status']) && $_GET['status'] == $value) selected @endif>{{ ucfirst($sts) }}</option>
                            @endforeach
                            </select>
                        </div>

                        <div class="col-md-3" style="text-align: left;">
                            <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                            <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

            @include('banners.table')
        </div>
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('banners.store') !!}" enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_banner_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="banner_type">{{__('lang.admin_type')}}</label>
                    <select id="banner_type" class="form-select" name="banner_type">
                        <option value="website">{{__('lang.admin_banner_website')}}</option>
                        <option value="app">{{__('lang.admin_banner_app')}}</option>
                    </select>
                </div>
                <div class="mb-1">
                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                    <div class="col-12 help-text">
                        <small class="text-muted">( {{__('lang.admin_banner_image_resolution')}} )</small>
                    </div>
                    <div class="col-12 d-flex mt-1 px-0">
                        <label class="btn btn-primary me-75 mb-0" for="change-picture">
                            <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                            <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                            <span class="d-block d-sm-none">
                                <i class="me-0" data-feather="edit"></i>
                            </span>
                        </label>
                    </div>
                </div>

                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_title')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="{{__('lang.admin_title')}}" aria-label="{{__('lang.admin_title')}}" name="title" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-sub_title">{{__('lang.admin_subtitle')}} <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-sub_title" id="basic-icon-default-sub_title" placeholder="{{__('lang.admin_subtitle')}}" aria-label="{{__('lang.admin_subtitle')}}" name="sub_title" required />
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
@endsection
