@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_banners')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/banners*') ? 'active' : '' }}"><a href="{!! route('banners.index') !!}">{{__('lang.admin_banner_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_banner_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($banner, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['banners.update', $banner->id]]) !!}
                                @csrf
                                <div class="mb-2">
                                    <h4>{{$banner->title}}</h4>
                                    @if($banner->image!='')
                                    <img src="{{asset('app-assets/images/banners/'.$banner->image)}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';"/>
                                    @else
                                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    @endif
                                    <div class="col-12 help-text">
                                        <small class="text-muted">( {{__('lang.admin_banner_image_resolution')}} )</small>
                                    </div>
                                    <div class="col-12 upload_btn_set" style="margin-left: 40px;">
                                        <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                            <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                            <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                                            <span class="d-block d-sm-none">
                                                <i class="me-0" data-feather="edit"></i>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_title')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_title')}}" value="{{$banner->title}}" name="title" id="username" required />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_subtitle')}} <span class="required">*</span></label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_subtitle')}}" value="{{$banner->sub_title}}" name="sub_title" id="username" required />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_type')}}</label>
                                            <select class="form-select" id="banner_type" name="banner_type">
                                                <option value="website" @if($banner->banner_type == 'web') selected  @endif>{{__('lang.admin_banner_website')}}</option>
                                                <option value="app" @if($banner->banner_type == 'app') selected  @endif>{{__('lang.admin_banner_app')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($banner->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($banner->status == 0) selected  @endif>{{__('lang.admin_deactivated')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('banners.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- coupons edit ends -->

        </div>
    </div>
</div>
<!-- END: Content-->
@endsection
