$(document).ready(function() {
    // Initialize tooltips
    $('[data-bs-toggle="tooltip"]').tooltip();

    // Get references to the switches and help text elements
    const $firebaseSwitch = $('#is_enable_firebase');
    const $twilioSwitch = $('#is_enable_twilio');
    const $testModeSwitch = $('#enable_test_mode');
    const $fast2smsSwitch = $('#is_enabled_fast_2_sms');
    const $2FactorSwitch = $('#is_enabled_2_factor');
    const $firebaseHelpText = $('#firebase-help-text');
    const $twilioHelpText = $('#twilio-help-text');
    const $testModeHelpText = $('#testmode-help-text');
    const $fast2smsHelpText = $('#fast2sms-help-text');
    const $2FactorHelpText = $('#Factor2-help-text');

    // Function to update help text based on current toggle states
    function updateHelpText() {
        if ($testModeSwitch.is(':checked')) {
            $firebaseHelpText.text('');
            $twilioHelpText.text('');
            $fast2smsHelpText.text('');
            $2FactorHelpText.text('');
            $testModeHelpText.text('(' + adminSetAsDefaultText + ')');
        } else if ($twilioSwitch.is(':checked')) {
            $firebaseHelpText.text('');
            $twilioHelpText.text('(' + adminSetAsDefaultText + ')');
            $fast2smsHelpText.text('');
            $testModeHelpText.text('');
            $2FactorHelpText.text('');
        } else if ($firebaseSwitch.is(':checked')) {
            $firebaseHelpText.text('(' + adminSetAsDefaultText + ')');
            $twilioHelpText.text('');
            $fast2smsHelpText.text('');
            $testModeHelpText.text('');
            $2FactorHelpText.text('');
        } else if ($fast2smsSwitch.is(':checked')) {
            $firebaseHelpText.text('');
            $twilioHelpText.text('');
            $fast2smsHelpText.text('(' + adminSetAsDefaultText + ')');
            $testModeHelpText.text('');
            $2FactorHelpText.text('');
        } else if ($2FactorSwitch.is(':checked')) {
            $firebaseHelpText.text('');
            $twilioHelpText.text('');
            $2FactorHelpText.text('(' + adminSetAsDefaultText + ')');
            $testModeHelpText.text('');
            $fast2smsHelpText.text('');
        } else {
            $firebaseHelpText.text('');
            $twilioHelpText.text('');
            $fast2smsHelpText.text('');
            $testModeHelpText.text('');
            $2FactorHelpText.text('');
        }
    }

    // Function to manage field states and switches
    function handleToggleSwitches() {
        const isFirebaseEnabled = $firebaseSwitch.is(':checked');
        const isTwilioEnabled = $twilioSwitch.is(':checked');
        const isTestModeEnabled = $testModeSwitch.is(':checked');
        const isFast2SmsEnabled = $fast2smsSwitch.is(':checked');
        const is2FactorEnabled = $2FactorSwitch.is(':checked');

        if (isFast2SmsEnabled) {
            saveDefaultSmsSettings('fast2sms');
            $firebaseSwitch.prop('checked', false);
            $twilioSwitch.prop('checked', false);
            $testModeSwitch.prop('checked', false);
            $2FactorSwitch.prop('checked', false);
            toggleReadonlyFields('.firebase_fields', true);
            toggleReadonlyFields('.twilio_fields', true);
            toggleReadonlyFields('.2factor_fields', true);
            toggleReadonlyFields('.fast2sms_fields', false);
        } else if (is2FactorEnabled) {
            saveDefaultSmsSettings('2factor');
            $firebaseSwitch.prop('checked', false);
            $twilioSwitch.prop('checked', false);
            $testModeSwitch.prop('checked', false);
            $fast2smsSwitch.prop('checked', false);
            toggleReadonlyFields('.firebase_fields', true);
            toggleReadonlyFields('.twilio_fields', true);
            toggleReadonlyFields('.fast2sms_fields', true);
            toggleReadonlyFields('.2factor_fields', false);
        } else if (isTwilioEnabled) {
            saveDefaultSmsSettings('twilio');
            $firebaseSwitch.prop('checked', false);
            $testModeSwitch.prop('checked', false);
            $fast2smsSwitch.prop('checked', false);
            $2FactorSwitch.prop('checked', false);
            toggleReadonlyFields('.firebase_fields', true);
            toggleReadonlyFields('.twilio_fields', false);
            toggleReadonlyFields('.fast2sms_fields', true);
        } else if (isFirebaseEnabled) {
            saveDefaultSmsSettings('firebase');
            $twilioSwitch.prop('checked', false);
            $testModeSwitch.prop('checked', false);
            $fast2smsSwitch.prop('checked', false);
            $2FactorSwitch.prop('checked', false);
            toggleReadonlyFields('.firebase_fields', false);
            toggleReadonlyFields('.twilio_fields', true);
            toggleReadonlyFields('.fast2sms_fields', true);
            toggleReadonlyFields('.2factor_fields', true);
        } else {
            toggleReadonlyFields('.firebase_fields', true);
            toggleReadonlyFields('.twilio_fields', true);
            toggleReadonlyFields('.fast2sms_fields', true);
            toggleReadonlyFields('.2factor_fields', true);
        }

        // Update help text
        updateHelpText();
    }

    // Function to toggle readonly fields
    function toggleReadonlyFields(fieldsClass, isReadonly) {
        $(fieldsClass).find('input, select, textarea').each(function() {
            $(this).prop('readonly', isReadonly);
            if ($(this).is('input[type="file"]')) {
                $(this).prop('disabled', isReadonly);
            }
        });
    }

    // Function to save default SMS settings
    function saveDefaultSmsSettings(key) {
        $.ajax({
            url: base_url + '/admin/settings/defaultSettings',
            type: 'POST',
            data: {
                key: key,
            },
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            },
            success: function(response) {
                console.log('Default settings updated successfully:', response);
            },
            error: function(xhr, status, error) {
                console.error('Error updating toggle state:', status, error);
            }
        });
    }

    // Add event listeners to the switches
    $firebaseSwitch.on('change', handleToggleSwitches);
    $twilioSwitch.on('change', handleToggleSwitches);
    $testModeSwitch.on('change', handleToggleSwitches);
    $fast2smsSwitch.on('change', handleToggleSwitches);
    $2FactorSwitch.on('change', handleToggleSwitches);

    // Initial setup based on the toggle switch states
    handleToggleSwitches();
});
