// Import the functions you need from the SDKs you need
import { initializeApp } from 'https://www.gstatic.com/firebasejs/9.6.1/firebase-app.js';
import { getMessaging, getToken, onMessage } from 'https://www.gstatic.com/firebasejs/9.6.1/firebase-messaging.js';

// Your Firebase configuration
const firebaseConfig = {
    apiKey: "",
    authDomain: "",
    projectId: "**********b9052",
    storageBucket: "",
    messagingSenderId: "",
    appId: "",
    measurementId: ""
};

// Initialize Firebase
const app = initializeApp(firebaseConfig);
const messaging = getMessaging(app);

// Request permission and get token
async function requestPermissionAndGetToken() {
    try {
        const permission = await Notification.requestPermission();
        if (permission === 'granted') {
            console.log('Notification permission granted.');
            const token = await getToken(messaging, { vapidKey: '' });

            if (token) {
                save_token(token);
                // You can send this token to your server for storing
            } else {
                console.log('No registration token available. Request permission to generate one.');
            }
        } else {
            console.log('Unable to get permission to notify.');
        }
    } catch (error) {
        console.error('An error occurred while retrieving token.', error);
    }
}
function save_token(token){
    let xhr = new XMLHttpRequest();
    xhr.open("post", "https://stagincite.technofox.co.in/f-d-r/fcm-token");

    xhr.setRequestHeader("Content-Type", "application/json");

    xhr.onload = () => console.log(xhr.responseText);

    let data = {
    token: token,
    "_token": document.getElementById('csrf_token_page').value,
    };
    xhr.send(JSON.stringify(data));
}

requestPermissionAndGetToken();

//Handle incoming messages
onMessage(messaging, (payload) => {
    console.log('Message received. ', payload);
    const notificationTitle = payload.notification.title;
    const notificationOptions = {
        body: payload.notification.body,
        icon: '/app-assets/images/users/20240422132320.jpg'
    };
    new Notification(notificationTitle, notificationOptions);
});


if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('/firebase-messaging-sw.js')
    .then((registration) => {
        console.log('Service Worker registered with scope:', registration.scope);
    })
    .catch((err) => {
        console.error('Service Worker registration failed:', err);
    });
}
