<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class UsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
{
    // Sample data for the users table
    $userData = [
        'type' => 'admin',
        'name' => 'Water App',
        'language_code' => 'en',
        'email' => 'admin@demo.com',
        'password' => Hash::make('admin'),
        'created_at' => now(),
        'role_id' => 1,
    ];

    // Check if the user with the same email already exists
    $existingUser = User::where('email', $userData['email'])->first();

    if (!$existingUser) {
        // Insert data into the users table if the user doesn't exist
        DB::table('users')->insert([$userData]);
    }

    // Rest of your code (creating role, assigning permissions, and assigning the role to the user)
    $isroleCheck = Role::where('name','admin')->first();
    if(!$isroleCheck){
        $role = Role::create([
            'name' => 'admin',
            'status' => 1,
            'guard_name' => 'web',
            'created_at' => now(),
        ]);
    }else{
        $role = Role::where('name','admin')->first();
    }

    $user = User::where('type', 'admin')->first();
    $permissions = Permission::pluck('id', 'id')->all();
    $role->syncPermissions($permissions);
    $user->assignRole([$role->id]);
}

}
