<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\LanguagesKeywords;

class TranslationsAPIKeywordSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       
        $mobile_translations = [
            "sign_in" => "Sign In",
            "sign_in_description" => "To Proceed Please Enter Your Phone Number\nWe will send you one time SMS message",
            "verify" => "VERIFY",
            "verify_now" => "VERIFY NOW",
            "create_account" => "CREATE ACCOUNT",
            "verification_code" => "Verification Code",
            "otp_sent_text" => "We have sent a 6-digit OTP to your number",
            "otp_sent_text_6digit" => "We have sent A 6-digit OTP to your number",
            "resend_again" => "Resend again?",
            "name" => "Name",
            "enter_password" => "Password",
            "order" => "Order",
            "order_nav" => "Order",
            "home" => "Home",
            "home_nav" => "Home",
            'invalid_otp' => 'Invalid Otp',
            'resend_otp_successfully' => 'Resend Otp',
            'successfully_add_to_cart' => 'Successfully Add To Cart',
            "offer" => "Offer",
            "profile" => "Profile",
            "your_account" => "Your Account",
            "your_information" => "Your Information",
            "full_name" => "Full Name",
            "address" => "Address",
            "your_preferences" => "Your Preferences",
            "notifications" => "Notifications",
            "password" => "Password",
            "card_holder_name" => "Cardholder Name",
            "card_number" => "Card Number",
            "expiry_date" => "Expiry Date",
            "security_code" => "Security Code",
            "save" => "SAVE",
            "your_orders" => "Your Orders",
            "payment" => "Payment",
            "total" => "Total",
            'total_order' => 'Total Order',
            "delivery_address" => "Delivery Address",
            "phone_number" => "Phone Number",
            "delivery_time" => "Delivery Time",
            "payment_method" => "Payment method",
            "order_time" => "Order Time",
            "no_of_items" => "No.of Items: 1 items",
            "quantity" => "Qty :",
            "offers" => "Offers",
            "order_details" => "Orders Details",
            "sub_total" => "Sub-total",
            "vat" => "VAT",
            "delivery" => "Delivery",
            "coupon_discount" => "Coupon Discount",
            "apply_coupon" => "Apply Coupon",
            "next" => "NEXT",
            "checkout" => "Checkout",
            'admin_check' => 'Check',
            'check' => 'Check',
            "choose_location" => "Choose Location",
            "add_address" => "Add Address",
            "work" => "Work",
            "pick_address" => "Pick Address",
            "select" => "SELECT",
            'select_pickup_address' => 'Please select the delivery address.', 
            "type" => "Type*",
            "address_title" => "Address Title*",
            "note" => "Note",
            "mosque" => "Mosque",
            "office" => "Office",
            "other" => "Other",
            "time_of_delivery" => "Time of delivery",
            "morning" => "Morning",
            "afternoon" => "Afternoon",
            "evening" => "Evening",
            "cash_on_delivery" => "Cash on delivery",
            "place_order" => "PLACE ORDER",
            'your_will_be_directed_to_the_home_page_automatically' => 'You will be directed to the home page automatically',
            "setting" => "Setting",
            "your_order" => "Your Order",
            "dark_mode" => "Dark Mode",
            "about_us" => "About Us",
            "contact_us" => "Contact Us",
            "term_and_condition" => "Term and conditions",
            "language" => "Language",
            "sign_out" => "Sign Out",
            "your_name" => "Your Name",
            "email_address" => "Email address",
            "send" => "SEND",
            "once" => "Once",
            "daily" => "Daily",
            "weekly" => "Weekly",
            "monthly" => "Monthly",
            "alternative" => "Alternative Days",
            "select_date" => "Select Date",
            "received" => "Received",
            "on_the_way" => "On the way",
            "delivered" => "Delivered",
            "payment_methods" => "Payment Methods",
            "create_account_title" => "Create Account",
            "enter_coupon_code" => "Enter Coupon code",
            "standard_free" => "Standard (free)",
            "apply_coupon_title" => "Apply",
            "apply_coupon_description" => "Add coupon to get exclusive discounts",
            "expire_on" => "Expire on",
            "balance" => "Balance",
            "select_language" => "Select Language",
            "all_right_reserve_text" => "Freshu © All Rights",
            "order_text" => "Order",
            "cash_on_delivery_text" => "Cash On Delivery",
            "order_placed" => "Order placed.",
            "your_order_number_is" => "Your order",
            "products" => "Products",
            "product_description" => "Product Description",
            "are_you_sure_quit_app" => "Are you sure want to quit the App ?",
            "are_you_sure_remove_from_cart" => "Do you want to remove item from cart?",
            "are_you_sure_cancel" => "Are you sure to cancel order ?",
            "selected_delivery_area_not_correct" => "Selected Delivery Area is not correct",
            "do_you_want_signout" => "Do you want to signout ?",
            "payment_cancelled" => "Payment Cancelled",
            "payment_error" => "Payment Error",
            "payment_success" => "Payment Success",
            "getting_search_result" => "Search Product",
            "go_to_home" => "Go To Home",
            "you_dont_have_any_orders" => "You don\'t have any orders yet",
            "you_dont_have_any_orders_yet" => "You do not have any orders yet",
            "you_are_up_to_date_would_work_well" => 'You are up to date worild work well',
            "go_shopping" => "Go Shopping",
            "no_offers" => "No Offers",
            "please_follow_our_offers_later" => "Please Follow our Offers later",
            "email" => "Email",
            "notification" => "Notifications",
            "select_botton" => "Select",
            "redirecting_in" => "Redirecting In",
            "resend_otp_in" => "Resend OTP in",
            "quit_app" => "Quit App",
            "no_notifications_right_now" => "No notification right now",
            "resend_opt_in" => "Resend Otp",
            "please_choose_some_products_to_buy" => "Please choose some product to buy",
            "enter_your_name" => "Enter your name",
            "enter_your_email" => "enter your email",
            "valid_email_is_required" => "valid email is required",
            "session_expired" => "Session expired",
            "ordered_products" => "Ordered Products",
            "customer" => "Customer",
            "order_id" => "Order Id",
            "view_details" => "View Details",
            "first_add_product_in_cart" => "Please, First add product in cart.",
            "cancel_request" => "CANCEL ORDER",
            "types_of_order" => "Type Of Order",
            'from_to' => 'From - To',
            'delivery_schedule' => 'Delivery Schedule',
            'contact_add_successfully' => 'Contact added successfully.',
            'data_not_available' => 'Data not available',
            'type_of_order' => 'Order Type',
            'something_went_wrong' => 'Something went wrong.',
            'payment_method_cash' => 'Cash',
            'splash_title_1' => 'Splash Screen 1',
            'splash_title_2' => 'Splash Screen 2',
            'items' => 'Items',
            'status' => 'Status',
            'items' => 'Items',
            'item' => 'Item',
            'cancel_order_help_text' =>'Note : Cancelled order payment will be transferred to wallet only.',
            'yes' => 'Yes',
            'no' => 'No',
            'delivery_date' => 'Delivery Date',
            'clear' => 'Clear',
            'change_name' => 'Change name',
            'update' => 'Update',
            'delivery_fee' => 'Delivery Fee',
            'cash' => 'Cash',
            'rate_us' => 'Rate Us',
            'state' => 'State',
            'city' => 'City',
            'zip_code' => 'Zipcode',
            'history' => 'History',
            'available_balance' => 'Available Balance',
            'wallet_usage_instruction' => 'Your balance can be used to make purchasing from dome water.',
            'add_amount' => 'Add Amount',
            'top_up_amount' => 'Top up Your Account',
            'add_to_cart'=>'Add To Cart',
            'add_balance' => 'Add Balance',
            'wallet' => 'Wallet',
            'payment_method_not_selected' => 'Payment Method not Selected',
            'add_amount_in_wallet_instruction' => 'You have not sufficient wallet amount, please add first.',
            'qty' => 'Qty',
            "add" => "Add",
            "added" => "Added",
            "select_days_for_delivery" => "Select date(s) for delivery",
            "quick_selection" => "Quick Selection",
            "weekdays" => "Weekdays",
            "weekend" => "Weekend",
            "is_required" => "is required",
            'share_your_app' => 'Share your app',
            'user_deactivated' => 'Deactived',
            'no_order_found' => 'No order found',
            'this_coupon_code_does_not_valid_now' => 'This coupon code does not valid now',
            'alert_cancel_order_request_submited' => 'Cancel order request submitted successfully',
            "no_result_found" => "No search results found",
            'select_alternative_days_instruction' => 'We are taking only alternative days from your below date range selection.',
            'enter_mobile' => 'Please, Enter mobile number.',
            'partners' => 'Partners',
            'awards' => 'Awards',
            'invalid_phone_number' => 'Invalid Phone Number',
            'tax' => 'Tax',
            'valid_phone_number' => 'Phone number must be between 6 to 10',
            'invalid_email' => 'Invalid Email',
            'order_assigned_successfully' => 'Order Assigned Successfully',
            'message_user_card_saved_successfully' => 'User card saved successfully',
            'message_user_card_fetch_successfully' => 'User card fetched successfully',
            'message_user_card_deleted_successfully' => 'User card deleted successfully',
            'message_user_card_updated_successfully' => 'User card updated successfully',
            'message_no_product_found' => 'No product found',
            'message_cart_fetch_successfully' => 'Cart fetched successfully',
            'message_add_to_cart_successfully' => 'Item added to cart successfully',
            'message_item_removed_successfully' => 'Item removed successfully',
            'message_something_went_wrong' => 'Something went wrong',
            'message_data_submitted_successfully' => 'Data submitted successfully',
            'message_data_retrieve_successfully' => 'Data retrieved successfully',
            'message_data_not_found' => 'Data not found',
            'saved_successfully' => 'Saved successfully',
            'admin_orders_retrieved_successfully' => 'Orders retrieved successfully',
            'message_do_hot_have_sufficient_blance_in_you_wallet' => 'You do not have sufficient balance in your wallet',
            'message_status_change_successfully' => 'Status changed successfully',
            'message_user_login_successfully_proceed_to_otp_verification' => 'User logged in successfully, proceed to OTP verification',
            'message_user_verified_logged_in_successfully' => 'User verified and logged in successfully',
            'message_invalid_otp' => 'Invalid OTP',
            'message_user_not_found' => 'User not found',
            'message_otp_send_successfully' => 'OTP sent successfully',
            'message_driver_is_inactive_now' => 'Driver is currently inactive',
            'message_invalid_password' => 'Invalid password',
            'message_mobile_number_already_exists' => 'Mobile number already exists',
            'message_email_already_exists' => 'Email already exists',
            'message_data_updated_successfully' => 'Data updated successfully',
            'message_data_created_successfully' => 'Data created successfully',
            'message_user_logout_successfully' => 'User logged out successfully',
            'message_driver_logout_successfully' => 'Driver logged out successfully',
            'message_driver_not_found' => 'Driver not found',
            'message_failed_to_send_otp' => 'Failed to send OTP',
            'message_otp_verified_successfully' => 'OTP verified successfully',
            'message_otp_verification_failed' => 'OTP verification failed',
            'message_payment_success' => 'Payment successful',
            'message_payment_failed' => 'Payment failed',
            'seconds' => 'Seconds',
            'sun' => 'Sun',
            'mon' => 'Mon',
            'tue' => 'Tue',
            'wed' => 'Wed',
            'thu' => 'Thu',
            'fri' => 'Fri',
            'sat' => 'Sat',
            'paid' => 'Paid',
            'unpaid' => 'Unpaid',
            'pending' => 'Pending',
            'delivered' => 'Delivered',
            'on_the_way' => 'On the Way',
            'ready' => 'Ready',
            'order_recieved' => 'Order Received',
            'not_delivered' => 'Not Delivered',
            'cancel_request_already_submitted' => 'CANCEL REQUEST SUBMITTED',
            'order_received' => 'Order Received',
            'Success' =>  'Success',
            'Error' =>  'Error',
            'logout_successfully' => 'Logged out successfully',
            'message_invalid_phone' => 'Invalid Phone Number',
            'order_assigned_successfully' =>  "Order Assigned Successfully",
            'message_profile_updated_successfully' => 'Profile updated successfully',

        ];

        foreach ($mobile_translations as $keyword => $translation) {
            $existsInApi = LanguagesKeywords::where('keyword', $keyword)
                ->where('group', 'api')
                ->where('lang_code', 'en')
                ->exists();

            if (!$existsInApi) {
                LanguagesKeywords::insert([
                        'keyword' => $keyword,
                        'value' => $translation,
                        'group' => 'api',
                        'lang_code' => 'en'
                ]);

            }
        }
    }
}
