<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\LanguagesKeywords;

class TranslationsAPIArabicKeywordSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       
        $mobile_translations = [
            "sign_in" => "تسجيل الدخول",
            "sign_in_description" => "للمتابعة، يرجى إدخال رقم هاتفك\nسنرسل لك رسالة SMS لمرة واحدة",
            "verify" => "تحقق",
            "verify_now" => "تحقق الآن",
            "create_account" => "إنشاء حساب",
            "verification_code" => "رمز التحقق",
            "otp_sent_text" => "لقد أرسلنا رمز تحقق مكون من 6 أرقام إلى رقمك",
            "otp_sent_text_6digit" => "لقد أرسلنا رمز تحقق مكون من 6 أرقام إلى رقمك",
            "resend_again" => "إعادة الإرسال؟",
            "name" => "الاسم",
            "enter_password" => "كلمة المرور",
            "order" => "طلب",
            "order_nav" => "الطلبات",
            "home" => "الرئيسية",
            "home_nav" => "الرئيسية",
            'invalid_otp' => 'رمز التحقق غير صالح',
            'resend_otp_successfully' => 'تم إرسال رمز التحقق مرة أخرى بنجاح',
            'successfully_add_to_cart' => 'تمت الإضافة إلى السلة بنجاح',
            "offer" => "عرض",

                       "profile" => "الملف الشخصي",
            "your_account" => "حسابك",
            "your_information" => "معلوماتك",
            "full_name" => "الاسم الكامل",
            "address" => "العنوان",
            "your_preferences" => "تفضيلاتك",
            "notifications" => "الإشعارات",
            "password" => "كلمة المرور",
            "card_holder_name" => "اسم حامل البطاقة",
            "card_number" => "رقم البطاقة",
            "expiry_date" => "تاريخ الانتهاء",
            "security_code" => "رمز الأمان",
            "save" => "حفظ",
            "your_orders" => "طلباتك",
            "payment" => "الدفع",
            "total" => "الإجمالي",
            "total_order" => "إجمالي الطلب",
            "delivery_address" => "عنوان التوصيل",
            "phone_number" => "رقم الهاتف",
            "delivery_time" => "وقت التوصيل",
            "payment_method" => "طريقة الدفع",
            "order_time" => "وقت الطلب",
            "no_of_items" => "عدد العناصر: عنصر واحد",
            "quantity" => "الكمية:",
            "offers" => "العروض",
            "order_details" => "تفاصيل الطلب",
            "sub_total" => "المجموع الفرعي",

                        "vat" => "ضريبة القيمة المضافة",
            "delivery" => "التوصيل",
            "coupon_discount" => "خصم القسيمة",
            "apply_coupon" => "تطبيق القسيمة",
            "next" => "التالي",
            "checkout" => "الدفع",
            "admin_check" => "تحقق",
            "check" => "تحقق",
            "choose_location" => "اختر الموقع",
            "add_address" => "إضافة عنوان",
            "work" => "العمل",
            "pick_address" => "اختر العنوان",
            "select" => "اختر",
            "select_pickup_address" => "يرجى اختيار عنوان التوصيل.",
            "type" => "النوع*",
            "address_title" => "عنوان العنوان*",
            "note" => "ملاحظة",
            "mosque" => "مسجد",
            "office" => "مكتب",
            "other" => "أخرى",
            "time_of_delivery" => "وقت التوصيل",
            "morning" => "الصباح",
            "afternoon" => "بعد الظهر",
            "evening" => "المساء",
            "cash_on_delivery" => "الدفع عند الاستلام",
            "place_order" => "إتمام الطلب",
            "your_will_be_directed_to_the_home_page_automatically" => "سيتم توجيهك إلى الصفحة الرئيسية تلقائيًا",
            "setting" => "الإعدادات",
            "your_order" => "طلبك",
            "dark_mode" => "الوضع الليلي",
            "about_us" => "معلومات عنا",
            "contact_us" => "اتصل بنا",
            "term_and_condition" => "الشروط والأحكام",
            "language" => "اللغة",
            "sign_out" => "تسجيل الخروج",

                      "your_name" => "اسمك",
            "email_address" => "عنوان البريد الإلكتروني",
            "send" => "إرسال",
            "once" => "مرة واحدة",
            "daily" => "يوميًا",
            "weekly" => "أسبوعيًا",
            "monthly" => "شهريًا",
            "alternative" => "أيام بديلة",
            "select_date" => "اختر التاريخ",
            "received" => "تم الاستلام",
            "on_the_way" => "في الطريق",
            "delivered" => "تم التوصيل",
            "payment_methods" => "طرق الدفع",
            "create_account_title" => "إنشاء حساب",
            "enter_coupon_code" => "أدخل رمز القسيمة",
            "standard_free" => "قياسي (مجاني)",
            "apply_coupon_title" => "تطبيق",
            "apply_coupon_description" => "أضف قسيمة للحصول على خصومات حصرية",
            "expire_on" => "ينتهي في",
            "balance" => "الرصيد",
            "select_language" => "اختر اللغة",
            "all_right_reserve_text" => "فريشو © جميع الحقوق محفوظة",
            "order_text" => "طلب",
            "cash_on_delivery_text" => "الدفع عند الاستلام",
            "order_placed" => "تم تقديم الطلب.",
            "your_order_number_is" => "رقم طلبك هو",
            "products" => "المنتجات",
            "product_description" => "وصف المنتج",
            "are_you_sure_quit_app" => "هل أنت متأكد أنك تريد الخروج من التطبيق؟",
            "are_you_sure_remove_from_cart" => "هل تريد إزالة العنصر من السلة؟",
            "are_you_sure_cancel" => "هل أنت متأكد من إلغاء الطلب؟",
            "selected_delivery_area_not_correct" => "منطقة التوصيل المحددة غير صحيحة",
            "do_you_want_signout" => "هل تريد تسجيل الخروج؟",
            "payment_cancelled" => "تم إلغاء الدفع",
            "payment_error" => "خطأ في الدفع",
            "payment_success" => "تم الدفع بنجاح",
            "getting_search_result" => "البحث عن منتج",

                        "go_to_home" => "الذهاب إلى الصفحة الرئيسية",
            "you_dont_have_any_orders" => "ليس لديك أي طلبات بعد",
            "you_dont_have_any_orders_yet" => "لا توجد لديك طلبات حتى الآن",
            "you_are_up_to_date_would_work_well" => "أنت محدث، كل شيء يعمل بشكل جيد",
            "go_shopping" => "تسوق الآن",
            "no_offers" => "لا توجد عروض",
            "please_follow_our_offers_later" => "يرجى متابعة عروضنا لاحقًا",
            "email" => "البريد الإلكتروني",
            "notification" => "الإشعارات",
            "select_botton" => "اختر",
            "redirecting_in" => "جارٍ التوجيه خلال",
            "resend_otp_in" => "إعادة إرسال رمز التحقق خلال",
            "quit_app" => "الخروج من التطبيق",
            "no_notifications_right_now" => "لا توجد إشعارات حالياً",
            "resend_opt_in" => "إعادة إرسال رمز التحقق",
            "please_choose_some_products_to_buy" => "يرجى اختيار بعض المنتجات للشراء",
            "enter_your_name" => "أدخل اسمك",
            "enter_your_email" => "أدخل بريدك الإلكتروني",
            "valid_email_is_required" => "البريد الإلكتروني الصحيح مطلوب",
            "session_expired" => "انتهت الجلسة",
            "ordered_products" => "المنتجات المطلوبة",
            "customer" => "العميل",
            "order_id" => "رقم الطلب",
            "view_details" => "عرض التفاصيل",
            "first_add_product_in_cart" => "يرجى إضافة منتج إلى السلة أولاً.",
            "cancel_request" => "إلغاء الطلب",
            "types_of_order" => "أنواع الطلبات",
            "from_to" => "من - إلى",
            "delivery_schedule" => "جدول التوصيل",
            "contact_add_successfully" => "تمت إضافة جهة الاتصال بنجاح.",
            "data_not_available" => "البيانات غير متوفرة",
            "type_of_order" => "نوع الطلب",
            "something_went_wrong" => "حدث خطأ ما.",
            "payment_method_cash" => "نقدًا",
            "splash_title_1" => "شاشة البداية 1",
            "splash_title_2" => "شاشة البداية 2",

                       'items' => 'العناصر',
            'status' => 'الحالة',
            'item' => 'عنصر',
            'cancel_order_help_text' => 'ملاحظة: سيتم تحويل مبلغ الطلب الملغى إلى المحفظة فقط.',
            'yes' => 'نعم',
            'no' => 'لا',
            'delivery_date' => 'تاريخ التوصيل',
            'clear' => 'مسح',
            'change_name' => 'تغيير الاسم',
            'update' => 'تحديث',
            'delivery_fee' => 'رسوم التوصيل',
            'cash' => 'نقدًا',
            'rate_us' => 'قيّمنا',
            'state' => 'الولاية',
            'city' => 'المدينة',
            'zip_code' => 'الرمز البريدي',
            'history' => 'السجل',
            'available_balance' => 'الرصيد المتاح',
            'wallet_usage_instruction' => 'يمكنك استخدام رصيدك لإجراء عمليات الشراء من دوم ووتر.',
            'add_amount' => 'إضافة مبلغ',
            'top_up_amount' => 'اشحن حسابك',
            'add_to_cart' => 'أضف إلى السلة',
            'add_balance' => 'إضافة رصيد',
            'wallet' => 'المحفظة',
            'payment_method_not_selected' => 'لم يتم اختيار طريقة الدفع',
            'add_amount_in_wallet_instruction' => 'لا يوجد رصيد كافٍ في المحفظة، يرجى الإضافة أولاً.',
            'qty' => 'الكمية',
            "add" => "إضافة",
            "added" => "تمت الإضافة",
            "select_days_for_delivery" => "اختر التاريخ/التواريخ للتوصيل",
            "quick_selection" => "اختيار سريع",
            "weekdays" => "أيام الأسبوع",
            "weekend" => "عطلة نهاية الأسبوع",
            "is_required" => "مطلوب",
            'share_your_app' => 'شارك تطبيقك',
            'user_deactivated' => 'تم التعطيل',
            'no_order_found' => 'لم يتم العثور على طلب',
            'no_result_found' => 'لم يتم العثور على نتائج بحث',
            'select_alternative_days_instruction' => 'نحن نعتمد فقط الأيام البديلة من نطاق التواريخ الذي حددته أدناه.',
            'enter_mobile' => 'يرجى إدخال رقم الجوال.',
            'this_coupon_code_does_not_valid_now' => 'رمز القسيمة هذا غير صالح الآن',
            'alert_cancel_order_request_submited' => 'تم إرسال طلب إلغاء الطلب بنجاح',
            'partners' => 'الشركاء',
            'awards' => 'الجوائز',
            'invalid_phone_number' => 'رقم الهاتف غير صالح',
            'tax' => 'الضريبة',
            'valid_phone_number' => 'يجب أن يكون رقم الهاتف بين 6 إلى 10 أرقام',
            'invalid_email' => 'البريد الإلكتروني غير صالح',
            'order_assigned_successfully' => 'تم تعيين الطلب بنجاح',
            'message_user_card_saved_successfully' => 'تم حفظ بطاقة المستخدم بنجاح',
            'message_user_card_fetch_successfully' => 'تم جلب بطاقة المستخدم بنجاح',
            'message_user_card_deleted_successfully' => 'تم حذف بطاقة المستخدم بنجاح',
            'message_user_card_updated_successfully' => 'تم تحديث بطاقة المستخدم بنجاح',
            'message_no_product_found' => 'لم يتم العثور على أي منتج',
            'message_cart_fetch_successfully' => 'تم جلب السلة بنجاح',
            'message_add_to_cart_successfully' => 'تمت إضافة العنصر إلى السلة بنجاح',
            'message_item_removed_successfully' => 'تمت إزالة العنصر بنجاح',
            'message_something_went_wrong' => 'حدث خطأ ما',
            'message_data_submitted_successfully' => 'تم إرسال البيانات بنجاح',
            'message_data_retrieve_successfully' => 'تم استرجاع البيانات بنجاح',
            'message_data_not_found' => 'البيانات غير موجودة',
            'saved_successfully' => 'تم الحفظ بنجاح',
            'admin_orders_retrieved_successfully' => 'تم جلب الطلبات بنجاح',
            'message_do_hot_have_sufficient_blance_in_you_wallet' => 'لا يوجد رصيد كافٍ في محفظتك',
            'message_status_change_successfully' => 'تم تغيير الحالة بنجاح',
            'message_user_login_successfully_proceed_to_otp_verification' => 'تم تسجيل دخول المستخدم بنجاح، تابع التحقق برمز OTP',
            'message_user_verified_logged_in_successfully' => 'تم التحقق من المستخدم وتسجيل الدخول بنجاح',
            'message_invalid_otp' => 'رمز التحقق غير صالح',
            'message_user_not_found' => 'المستخدم غير موجود',
            'message_otp_send_successfully' => 'تم إرسال رمز التحقق بنجاح',
            'message_driver_is_inactive_now' => 'السائق غير نشط حالياً',
            'message_invalid_password' => 'كلمة المرور غير صحيحة',
            'message_mobile_number_already_exists' => 'رقم الهاتف موجود بالفعل',
            'message_email_already_exists' => 'البريد الإلكتروني موجود بالفعل',
            'message_data_updated_successfully' => 'تم تحديث البيانات بنجاح',
            'message_data_created_successfully' => 'تم إنشاء البيانات بنجاح',
            'message_user_logout_successfully' => 'تم تسجيل خروج المستخدم بنجاح',
            'message_driver_logout_successfully' => 'تم تسجيل خروج السائق بنجاح',
            'message_driver_not_found' => 'السائق غير موجود',
            'message_failed_to_send_otp' => 'فشل في إرسال رمز التحقق',
            'message_otp_verified_successfully' => 'تم التحقق من رمز التحقق بنجاح',
            'message_otp_verification_failed' => 'فشل في التحقق من رمز التحقق',
            'message_payment_success' => 'تم الدفع بنجاح',
            'message_payment_failed' => 'فشل الدفع',
            'seconds' => 'ثواني',
            'sun' => 'الأحد',
            'mon' => 'الاثنين',
            'tue' => 'الثلاثاء',
            'wed' => 'الأربعاء',
            'thu' => 'الخميس',
            'fri' => 'الجمعة',
            'sat' => 'السبت',
            'paid' => 'مدفوع',
            'unpaid' => 'غير مدفوع',
            'pending' => 'قيد الانتظار',
            'delivered' => 'تم التسليم',
            'on_the_way' => 'في الطريق',
            'ready' => 'جاهز',
            'order_recieved' => 'تم استلام الطلب',
            'not_delivered' => 'لم يتم التسليم',
            'cancel_request_already_submitted'  =>  'تم إرسال طلب الإلغاء مسبقًا.',
            'order_received' => 'تم استلام الطلب',
            'Success' => 'نجاح',
            'logout_successfully' => 'تم تسجيل الخروج بنجاح',
            'message_invalid_phone' => 'رقم الهاتف غير صالح',
            'Error' => 'خطأ',
            'order_assigned_successfully' => 'تم تعيين الطلب بنجاح',
            'message_profile_updated_successfully' => 'تم تحديث الملف الشخصي بنجاح',



        ];

        foreach ($mobile_translations as $keyword => $translation) {
            $existsInApi = LanguagesKeywords::where('keyword', $keyword)
                ->where('group', 'api')
                ->where('lang_code', 'ar')
                ->where('value',$translation)
                ->exists();

            if (!$existsInApi) {
                
                // delete
                $existsInApi = LanguagesKeywords::where(DB::raw('BINARY `keyword`'), $keyword)
                    ->where('group','api')
                    ->where('lang_code','ar')
                    ->delete();

                LanguagesKeywords::insert([
                        'keyword' => $keyword,
                        'value' => $translation,
                        'group' => 'api',
                        'lang_code' => 'ar'
                ]);

            }
        }
    }
}