<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TimeslotsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Define the data to be seeded
        $timeslots = [
            [
                'name' => 'Morning',
                'from_time' => '07:00:00',
                'to_time' => '12:00:00',
                'status' => 1,
            ],
            // Add more timeslot data as needed
        ];

        // Insert data into the timeslots table if the name does not exist
        foreach ($timeslots as $timeslot) {
            $existingTimeslot = DB::table('timeslots')->where('name', $timeslot['name'])->first();

            if (!$existingTimeslot) {
                // Assign values from $timeslot using array indexing
                $name = $timeslot['name'];
                $from_time = $timeslot['from_time'];
                $to_time = $timeslot['to_time'];

                // Add timestamps before inserting
                $created_at = now();
                $updated_at = now();

                // Insert into the timeslots table
                DB::table('timeslots')->insert(compact('name', 'from_time', 'to_time', 'created_at', 'updated_at'));
            }
        }
    }
}
