<?php
  
namespace Database\Seeders;
  
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
  
class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    // php artisan db:seed --class=PermissionTableSeeder

     public function run(): void
    {
        $tempArr = array(
            array('module' => 'Role','route_name' => 'role','permission_name' => 'List','group' => 'role','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Role','route_name' => 'add-role','permission_name' => 'Add','group' => 'role','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Role','route_name' => 'update-role','permission_name' => 'Update','group' => 'role','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Role','route_name' => 'update-role-status','permission_name' => 'Status Change','group' => 'role','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Role','route_name' => 'delete-role','permission_name' => 'Delete','group' => 'role','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Subadmin','route_name' => 'sub-admin','permission_name' => 'List','group' => 'sub-admin','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Subadmin','route_name' => 'add-sub-admin','permission_name' => 'Add','group' => 'sub-admin','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Subadmin','route_name' => 'update-sub-admin','permission_name' => 'Update','group' => 'sub-admin','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'Subadmin','route_name' => 'update-sub-admin-status','permission_name' => 'Status Change','group' => 'sub-admin','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Subadmin','route_name' => 'delete-sub-admin','permission_name' => 'Delete','group' => 'sub-admin','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Subadmin','route_name' => 'sub-admin-translation','permission_name' => 'Translation','group' => 'sub-admin','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Dashboard','route_name' => 'dashboard','permission_name' => 'Dashboard','group' => 'dashboard','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Product','route_name' => 'products','permission_name' => 'List','group' => 'products','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Product','route_name' => 'add-product','permission_name' => 'Add','group' => 'products','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Product','route_name' => 'update-product','permission_name' => 'Update','group' => 'products','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Product','route_name' => 'update-product-column','permission_name' => 'Status Change','group' => 'products','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Product','route_name' => 'delete-product','permission_name' => 'Delete','group' => 'products','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Product','route_name' => 'translation-product','permission_name' => 'Translation','group' => 'products','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'User','route_name' => 'users','permission_name' => 'List','group' => 'user','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'User','route_name' => 'add-user','permission_name' => 'Add','group' => 'user','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'User','route_name' => 'update-user','permission_name' => 'Update','group' => 'user','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'User','route_name' => 'update-user-status','permission_name' => 'Status Change','group' => 'user','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'User','route_name' => 'delete-user','permission_name' => 'Delete','group' => 'user','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'User','route_name' => 'add-wallet','permission_name' => 'Wallet','group' => 'user','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Driver','route_name' => 'drivers','permission_name' => 'List','group' => 'driver','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Driver','route_name' => 'add-driver','permission_name' => 'Add','group' => 'driver','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Driver','route_name' => 'update-driver','permission_name' => 'Update','group' => 'driver','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Driver','route_name' => 'update-driver-status','permission_name' => 'Status Change','group' => 'driver','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Driver','route_name' => 'delete-driver','permission_name' => 'Delete','group' => 'driver','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Order','route_name' => 'orders','permission_name' => 'List','group' => 'order','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Order Cancel Request','route_name' => 'cancel-order-request','permission_name' => 'List','group' => 'cancel-order-request','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Order Delivery','route_name' => 'delivery','permission_name' => 'List','group' => 'delivery','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Order Revenue','route_name' => 'revenue','permission_name' => 'List','group' => 'revenue','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Order Subscription','route_name' => 'subscription','permission_name' => 'List','group' => 'subscription','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Order','route_name' => 'update-order','permission_name' => 'Update','group' => 'order','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Order','route_name' => 'delete-order','permission_name' => 'Delete','group' => 'order','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Order','route_name' => 'update-order-status','permission_name' => 'Status Change','group' => 'order','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Order','route_name' => 'detail-order','permission_name' => 'Detail','group' => 'order','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Payment','route_name' => 'payments','permission_name' => 'List','group' => 'payment','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Banner','route_name' => 'banners','permission_name' => 'List','group' => 'banner','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Banner','route_name' => 'add-banner','permission_name' => 'Add','group' => 'banner','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Banner','route_name' => 'update-banner','permission_name' => 'Update','group' => 'banner','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'Banner','route_name' => 'update-banner-status','permission_name' => 'Status Change','group' => 'banner','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Banner','route_name' => 'delete-banner','permission_name' => 'Delete','group' => 'banner','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Banner','route_name' => 'banner-translation','permission_name' => 'Translation','group' => 'banner','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Coupon','route_name' => 'coupons','permission_name' => 'List','group' => 'coupan','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Coupon','route_name' => 'add-coupon','permission_name' => 'Add','group' => 'coupan','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Coupon','route_name' => 'update-coupon','permission_name' => 'Update','group' => 'coupan','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'Coupon','route_name' => 'update-coupon-status','permission_name' => 'Status Change','group' => 'coupan','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Coupon','route_name' => 'delete-coupon','permission_name' => 'Delete','group' => 'coupan','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Coupon','route_name' => 'coupon-translation','permission_name' => 'Translation','group' => 'coupan','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'SiteContent','route_name' => 'site_contents','permission_name' => 'List','group' => 'site_content','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'SiteContent','route_name' => 'update-site_content','permission_name' => 'Update','group' => 'site_content','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'SiteContent','route_name' => 'site_content-translation','permission_name' => 'Translation','group' => 'site_content','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Contact Us','route_name' => 'contact_us','permission_name' => 'List','group' => 'contact_us','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Contact Us','route_name' => 'reply-contact_us','permission_name' => 'Reply','group' => 'contact_us','is_default' => 0,'guard_name' => 'web'),

            array('module' => 'About Us','route_name' => 'about_us','permission_name' => 'List','group' => 'about_us','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'About Us','route_name' => 'add-about_us','permission_name' => 'Add','group' => 'about_us','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'About Us','route_name' => 'update-about_us','permission_name' => 'Update','group' => 'about_us','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'About Us','route_name' => 'update-about_us-status','permission_name' => 'Status Change','group' => 'about_us','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'About Us','route_name' => 'delete-about_us','permission_name' => 'Delete','group' => 'about_us','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'About Us','route_name' => 'about_us-translation','permission_name' => 'Translation','group' => 'about_us','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Settings','route_name' => 'all-settings','permission_name' => 'List','group' => 'settings','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Settings','route_name' => 'update-settings','permission_name' => 'Update','group' => 'settings','is_default' => 0,'guard_name' => 'web'),
            

            array('module' => 'Holiday','route_name' => 'holidays','permission_name' => 'List','group' => 'holiday','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Holiday','route_name' => 'add-holiday','permission_name' => 'Add','group' => 'holiday','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Holiday','route_name' => 'update-holiday','permission_name' => 'Update','group' => 'holiday','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'Holiday','route_name' => 'update-holiday-status','permission_name' => 'Status Change','group' => 'holiday','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Holiday','route_name' => 'delete-holiday','permission_name' => 'Delete','group' => 'holiday','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Holiday','route_name' => 'holiday-translation','permission_name' => 'Translation','group' => 'holiday','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Delivery Area','route_name' => 'delivery_areas','permission_name' => 'List','group' => 'delivery_area','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Delivery Area','route_name' => 'add-delivery_area','permission_name' => 'Add','group' => 'delivery_area','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Delivery Area','route_name' => 'update-delivery_area','permission_name' => 'Update','group' => 'delivery_area','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'Delivery Area','route_name' => 'update-delivery_area-status','permission_name' => 'Status Change','group' => 'delivery_area','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Delivery Area','route_name' => 'delete-delivery_area','permission_name' => 'Delete','group' => 'delivery_area','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Delivery Area','route_name' => 'delivery_area-translation','permission_name' => 'Translation','group' => 'delivery_area','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Timeslot','route_name' => 'timeslots','permission_name' => 'List','group' => 'timeslot','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Timeslot','route_name' => 'add-timeslots','permission_name' => 'Add','group' => 'timeslot','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Timeslot','route_name' => 'update-timeslots','permission_name' => 'Update','group' => 'timeslot','is_default' => 0,'guard_name' => 'web'),
            array('module' => 'Timeslot','route_name' => 'update-timeslots-status','permission_name' => 'Status Change','group' => 'timeslot','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Timeslot','route_name' => 'delete-timeslots','permission_name' => 'Delete','group' => 'timeslot','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Timeslot','route_name' => 'timeslots-translation','permission_name' => 'Translation','group' => 'timeslot','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Currency', 'route_name' => 'currencies', 'permission_name' => 'List', 'group' => 'currencies', 'is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Currency', 'route_name' => 'add-currencies', 'permission_name' => 'Add', 'group' => 'currencies', 'is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Currency', 'route_name' => 'update-currencies', 'permission_name' => 'Update', 'group' => 'currencies', 'is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Currency', 'route_name' => 'update-currencies-status', 'permission_name' => 'Status Change', 'group' => 'currencies', 'is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Currency', 'route_name' => 'delete-currencies', 'permission_name' => 'Delete', 'group' => 'currencies', 'is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Currency', 'route_name' => 'currencies-translation', 'permission_name' => 'Translation', 'group' => 'currencies', 'is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Language','route_name' => 'languages','permission_name' => 'List','group' => 'language','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Language','route_name' => 'add-languages','permission_name' => 'Add','group' => 'language','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Language','route_name' => 'update-languages','permission_name' => 'Update','group' => 'language','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Language','route_name' => 'update-languages-status','permission_name' => 'Status Change','group' => 'language','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Language','route_name' => 'delete-languages','permission_name' => 'Delete','group' => 'language','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Language Keyword','route_name' => 'keywords','permission_name' => 'List','group' => 'keywords','is_default' => 0, 'guard_name' => 'web'),
             array('module' => 'Language Keyword','route_name' => 'add-keywords','permission_name' => 'Add','group' => 'keywords','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Language Keyword','route_name' => 'update-keywords','permission_name' => 'Update','group' => 'keywords','is_default' => 0, 'guard_name' => 'web'),

            array('module' => 'Push Notification','route_name' => 'notifications','permission_name' => 'List','group' => 'notification','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Push Notification','route_name' => 'add-notifications','permission_name' => 'Add','group' => 'notification','is_default' => 0, 'guard_name' => 'web'),
            array('module' => 'Push Notification','route_name' => 'delete-notifications','permission_name' => 'Delete','group' => 'notification','is_default' => 0, 'guard_name' => 'web'),

             array('module' => 'Update Website','route_name' => 'check-update','permission_name' => 'List','group' => 'check_update','is_default' => 0, 'guard_name' => 'web'),
            
        );
         
        foreach ($tempArr as $key => $value) {
        // Check if the permission already exists
        $existingPermission = Permission::where('name', $value['route_name'])
            ->where('guard_name', $value['guard_name'])
            ->first();

            if (!$existingPermission) {
                // Insert the permission if it doesn't exist
                Permission::insert([
                    'module' => $value['module'],
                    'name' => $value['route_name'],
                    'permission_name' => $value['permission_name'],
                    'group' => $value['group'],
                    'guard_name' => $value['guard_name'],
                    'is_default' => $value['is_default'],
                    'created_at' => now(),
                ]);
            }


        }

}

}