<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class OrderStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
{
    // Define the data to be seeded
    $orderStatusData = [
        [
            'status' => 'Pending',
        ],
        [
            'status' => 'Ready',
        ],
        [
            'status' => 'On the Way',
        ],
        [
            'status' => 'Delivered',
        ],
        [
            'status' => 'Cancelled',
        ],
        [
            'status' => 'Order Received',
        ],
        [
            'status' => 'Not Delivered',
        ],
        // Add more order statuses as needed
    ];

    // Insert data into the order_statuses table if the status does not exist
    foreach ($orderStatusData as $orderStatus) {
        $existingOrderStatus = DB::table('order_statuses')->where('status', $orderStatus['status'])->first();

        if (!$existingOrderStatus) {
            DB::table('order_statuses')->insert($orderStatus);
        }
    }
}

}
