<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrenciesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
public function run()
{
    // Define the data to be seeded
    $currenciesData = [
        [
            'name' => 'US Dollar',
            'symbol' => '$',
            'code' => 'USD',
            'decimal_digits' => 2,
            'rounding' => 0,
            'status' => 1,
            'is_default' => 1,
        ],
        // Add more currencies as needed
    ];

    // Insert data into the currencies table if the code does not exist
    foreach ($currenciesData as $currency) {
        $existingCurrency = DB::table('currencies')->where('code', $currency['code'])->first();

        if (!$existingCurrency) {
            DB::table('currencies')->insert($currency);
        }
    }
}

}
