<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Models\Languages;
use App\Models\LanguagesKeywords;

class CreateTranslationsFileOfDefaultLang extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Define the data to be seeded
        $languagesData = [
            [
                'language_name' => 'English',
                'language_code' => 'en',
                'language_direction' => 'ltr',
                'is_default' => 1,
                'status' => 1,
            ],
            [
                'language_name' => 'Arabic',
                'language_code' => 'ar',
                'language_direction' => 'rtl',
                'is_default' => 0,
                'status' => 1,
            ],
        ];

        // Insert data into the languages table if the language code does not exist
        foreach ($languagesData as $language) {
            $existingLanguage = DB::table('languages')->where('language_code', $language['language_code'])->first();

            if (!$existingLanguage) {
                DB::table('languages')->insert($language);
            }
        }

        // Generate translation files for each language
        $this->generateTranslationFile('en');
        $this->generateTranslationFile('ar');
    }

    /**
     * Generate translation file for a given language.
     *
     * @param string $languageCode
     * @return void
     */
    private function generateTranslationFile($languageCode)
    {
        $fileName = 'lang.php';
        $path = resource_path("lang/{$languageCode}"); 
        $filePath = "{$path}/{$fileName}";

        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        if (!file_exists($filePath)) {
            file_put_contents($filePath, '<?php return [];');
        }

        $language = Languages::where('language_code', $languageCode)->first();
        if ($language) {
            $detail = "<?php\nreturn [\n";
            $translations = LanguagesKeywords::where('lang_code', $languageCode)->get();
            foreach ($translations as $row) {
                $row->value = str_replace("'", "", $row->value);
                $detail .= "    '".$row->keyword."' => '".$row->value."',\n";
            }
            $detail .= "];";

            File::put($filePath, $detail);
        }
    }
}
