<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CmsContentsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
{
    // Define the data to be seeded
    $cmsContentsData = [
        [
            'page_name' => 'about',
            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
            'page_title' => 'About Us',
        ],
        [
            'page_name' => 'policy',
            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
            'page_title' => 'Privacy Policy',
        ],
        [
            'page_name' => 'terms',
            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
            'page_title' => 'Terms & Conditions',
        ],
        
        // Add more CMS content data as needed
    ];

    // Insert data into the cms_contents table if the page_name does not exist
    foreach ($cmsContentsData as $cmsContent) {
        $existingCmsContent = DB::table('cms_contents')->where('page_name', $cmsContent['page_name'])->first();

        if (!$existingCmsContent) {
            DB::table('cms_contents')->insert($cmsContent);
        }
    }
}

}
