<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BannersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
{
    // Define the data to be seeded
    $banners = [
        ['image' => '', 'title' => 'Bottled Water Delivery', 'sub_title' => 'Pellentesque ultricies et sem non placerat. Vestibulum non urna vestibulum, ornare felis vela', 'banner_type' => 'website', 'status' => '1'],
    ];

    // Insert data into the banners table if the title does not exist
    foreach ($banners as $banner) {
        $existingBanner = DB::table('banners')->where('title', $banner['title'])->first();

        if (!$existingBanner) {
            DB::table('banners')->insert($banner);
        }
    }
}

}
