<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use anlutro\LaravelSettings\Facade as ContentSetting;

class AppSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
     public function run()
    {
        // Define the data to be seeded
        $settings = [
            ['key' => 'timezone', 'value' => 'Asia/Riyadh', 'updated_at' => '2023-08-03 07:37:46'],
            ['key' => 'language', 'value' => 'en', 'updated_at' => null],
            ['key' => 'fcm_key', 'value' => '', 'updated_at' => '2021-08-30 09:24:21'],
            ['key' => 'default_tax', 'value' => 0, 'updated_at' => '2023-08-03 07:37:46'],
            ['key' => 'shipping_charge', 'value' => 0, 'updated_at' => '2023-08-03 07:37:46'],
            ['key' => 'minimum_order_value', 'value' => 0, 'updated_at' => '2023-08-03 07:37:46'],
            ['key' => 'currency_right', 'value' => 0, 'updated_at' => null],
            ['key' => 'default_currency', 'value' => '$', 'updated_at' => '2023-02-08 12:16:58'],
            ['key' => 'default_currency_code', 'value' => 'USD', 'updated_at' => '2023-02-08 12:16:58'],
            ['key' => 'default_currency_decimal_digits', 'value' => 2, 'updated_at' => '2023-02-08 12:16:58'],
            ['key' => 'default_currency_rounding', 'value' => 0, 'updated_at' => '2023-02-08 12:16:58'],
            ['key' => 'deliver_turnaround_days', 'value' => 0, 'updated_at' => null],
            ['key' => 'max_delivery_extension', 'value' => 0, 'updated_at' => null],
            ['key' => 'facebook_url', 'value' => '', 'updated_at' => '2021-09-09 17:00:53'],
            ['key' => 'twitter_url', 'value' => '', 'updated_at' => '2021-09-09 17:00:53'],
            ['key' => 'instagram_url', 'value' => '', 'updated_at' => '2021-09-09 17:00:53'],
            ['key' => 'pinterest_url', 'value' => '', 'updated_at' => '2021-09-09 17:00:53'],
            ['key' => 'snapchat_url', 'value' => '', 'updated_at' => '2021-09-09 17:00:53'],
            ['key' => 'enable_razorpay', 'value' => 0, 'updated_at' => '2023-02-08 12:16:13'],
            ['key' => 'razorpay_key', 'value' => '', 'updated_at' => '2023-02-08 12:16:13'],
            ['key' => 'razorpay_secret', 'value' => '', 'updated_at' => '2023-02-08 12:16:13'],
            ['key' => 'enable_eghl', 'value' => 0, 'updated_at' => '2021-07-15 08:59:04'],
            ['key' => 'eghl_serviceid', 'value' => 0, 'updated_at' => '2021-07-15 08:59:04'],
            ['key' => 'eghl_password', 'value' => 0, 'updated_at' => '2021-07-15 08:59:04'],
            ['key' => 'youtube_video_url', 'value' => '', 'updated_at' => '2023-08-03 13:07:19'],
            ['key' => 'apple_download_url', 'value' => '', 'updated_at' => '2023-08-03 13:07:19'],
            ['key' => 'android_download_url', 'value' => '', 'updated_at' => '2023-08-03 13:07:19'],
            ['key' => 'contact_phone', 'value' => '+399 399 233 166', 'updated_at' => '2023-08-03 13:07:19'],
            ['key' => 'contact_email', 'value' => 'rishabh@fluttertop.com', 'updated_at' => '2023-08-03 13:07:19'],
            ['key' => 'contact_address', 'value' => 'dKing Fahed St', 'updated_at' => '2023-08-03 13:07:19'],
            ['key' => 'support_phone', 'value' => '920000123', 'updated_at' => null],
            ['key' => 'contact_support_phone', 'value' => '+919171243650', 'updated_at' => '2023-08-03 13:07:20'],
            ['key' => 'site_title', 'value' => 'Freshu Water APP Mobile APP', 'updated_at' => '2023-08-03 13:07:20'],
            ['key' => 'site_author', 'value' => 'Freshu Water APP Mobile APP', 'updated_at' => '2023-08-03 13:07:20'],
            ['key' => 'site_description', 'value' => 'Freshu Water APP Mobile APP', 'updated_at' => '2023-08-03 13:07:20'],
            ['key' => 'site_keyword', 'value' => 'Freshu Water APP Mobile APP', 'updated_at' => '2023-08-03 13:07:20'],
            ['key' => 'google_analytics', 'value' => null, 'updated_at' => null],
            ['key' => 'website_logo', 'value' => '', 'updated_at' => '2023-08-03 13:07:20'],
            ['key' => 'about_product', 'value' => '', 'updated_at' => '2023-08-03 09:09:01'],
            ['key' => 'mobile_image', 'value' => '', 'updated_at' => '2021-08-14 03:29:50'],
            ['key' => 'icon_1', 'value' => '', 'updated_at' => '2023-08-03 09:05:26'],
            ['key' => 'icon_2', 'value' => '', 'updated_at' => '2023-08-03 09:05:26'],
            ['key' => 'icon_3', 'value' => '', 'updated_at' => '2023-08-03 09:05:26'],
            ['key' => 'icon_4', 'value' => '', 'updated_at' => '2023-08-03 09:05:26'],
            ['key' => 'website_bg_image', 'value' => '', 'updated_at' => '2023-07-08 11:58:40'],
            ['key' => 'enable_paylab', 'value' => 0, 'updated_at' => '2022-01-03 10:08:01'],
            ['key' => 'enable_cod', 'value' => 1, 'updated_at' => '2023-02-08 12:16:13'],
            ['key' => 'enable_wallet', 'value' => 0, 'updated_at' => '2023-02-08 12:16:13'],
            ['key' => 'mon_working', 'value' => 0, 'updated_at' => '2021-10-01 00:00:00'],
            ['key' => 'tue_working', 'value' => 0, 'updated_at' => '2021-10-01 00:00:00'],
            ['key' => 'wed_working', 'value' => 0, 'updated_at' => '2021-10-01 00:00:00'],
            ['key' => 'thu_working', 'value' => 0, 'updated_at' => '2021-10-01 00:00:00'],
            ['key' => 'fri_working', 'value' => 0, 'updated_at' => '2021-10-01 00:00:00'],
            ['key' => 'sat_working', 'value' => 0, 'updated_at' => '2021-10-01 00:00:00'],
            ['key' => 'sun_working', 'value' => 0, 'updated_at' => '2021-10-01 00:00:00'],
            ['key' => 'enable_oppwa', 'value' => 0, 'updated_at' => '2023-02-08 12:16:13'],
            ['key' => 'date_format', 'value' => 'l jS F Y', 'updated_at' => '2023-08-03 07:37:47'],
            ['key' => 'date_time_format', 'value' => 'l jS F Y (H:i:s)', 'updated_at' => '2023-08-03 07:37:47'],
            ['key' => 'time_format', 'value' => 'H:i:s', 'updated_at' => '2023-08-03 07:37:47'],

            ['key' => 'is_enable_one_signal', 'value' => '0', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'one_signal_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'one_signal_app_id', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'is_enable_firebase', 'value' => '0', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'is_enable_firebase_notification', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'firebase_msg_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'firebase_api_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'mail_driver', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'mail_host', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'mail_port', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'mail_username', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'mail_password', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'mail_encrytion', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'mail_from_address', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'mail_from_name', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'enable_firebase_message', 'value' => '0', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'is_enable_twilio', 'value' => '0', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'twilio_account_sid', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'twilio_auth_token', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'twilio_phone_number', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],


            ['key' => 'is_enable_msg91', 'value' => '0', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'msg91_auth_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'msg91_sender_id', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'google_map_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'google_translate_api_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'app_logo', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'website_favicon', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'android_schema_url', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'playstore_url', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'ios_schema_url', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'appstore_url', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'bundle_id_android', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'bundle_id_ios', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'enable_paypal', 'value' => 0, 'updated_at' => '2021-07-15 08:58:46'],
            ['key' => 'paypal_client_id', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'paypal_secret_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'enable_stripe', 'value' => 0, 'updated_at' => '2021-07-15 08:58:46'],
            ['key' => 'stripe_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'stripe_secret_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'enable_paytm', 'value' => 0, 'updated_at' => '2021-07-15 08:58:46'],
            ['key' => 'paytm_merchant_id', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'paytm_merchant_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'paytm_merchant_website', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'paytm_channel', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'paytm_industry_type', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],


            ['key' => 'enable_phonepe', 'value' => 0, 'updated_at' => '2021-07-15 08:58:46'],
            ['key' => 'phonepe_merchant_id', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'phonepe_merchant_user_id', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'phonepe_merchant_transactionId', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'phonepe_salt_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'phonepe_salt_index', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'phonepe_callback_url', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'phonepe_redirect_url', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'phone_redirect_mode', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'enable_instamojo', 'value' => 0, 'updated_at' => '2021-07-15 08:58:46'],
            ['key' => 'instamojo_api_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'instamojo_auth_token', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'instamojo_api_endpoint', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],


            ['key' => 'enable_flutterwave', 'value' => 0, 'updated_at' => '2021-07-15 08:58:46'],
            ['key' => 'rave_public_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'rave_secret_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'rave_encryption_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'enable_paystack', 'value' => 0, 'updated_at' => '2021-07-15 08:58:46'],
            ['key' => 'paystack_public_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],
            ['key' => 'paystack_secret_key', 'value' => '', 'updated_at' => '2023-12-20 07:37:47'],

            ['key' => 'enable_test_mode', 'value' => '1', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'countryCodes', 'value' => '["in"]', 'updated_at' => '2024-08-08 07:37:47'],

            ['key' => 'firebase_app_id', 'value' => '', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'google_address_longitude', 'value' => '77.1025', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'google_address_latitude', 'value' => '28.7041', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'is_enable_mail_order_receive', 'value' => '', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'paypal_app_id', 'value' => '', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'paystack_merchant_email', 'value' => '', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'firebase_messaging_vapid_publickey', 'value' => '', 'updated_at' => '2024-08-08 07:37:47'],
            ['key' => 'splash_screen', 'value' => 'default-splash-screen.png', 'updated_at' => ''],
            ['key' => 'is_enable_google_map_address', 'value' => 0, 'updated_at' => ''],
            ['key' => 'is_enable_app_google_map_address', 'value' => 0, 'updated_at' => ''],
            ['key' => 'is_enabled_fast_2_sms', 'value' => 0, 'updated_at' => ''],
            ['key' => 'fast_2_sms_sender_id', 'value' => '', 'updated_at' => ''],
            ['key' => 'fast_2_sms_api_key', 'value' => '', 'updated_at' => ''],

            ['key' => 'is_enabled_2_factor', 'value' => 0, 'updated_at' => ''],
            ['key' => '2_factor_api_key', 'value' => '', 'updated_at' => ''],

            ['key' => 'enable_liqpay', 'value' => 0, 'updated_at' => ''],
            ['key' => 'liqpay_public_key', 'value' => '', 'updated_at' => ''],
            ['key' => 'liqpay_private_key', 'value' => '', 'updated_at' => ''],

            ['key' => 'is_android_app_force_update', 'value' => 0, 'updated_at' => ''],
            ['key' => 'is_ios_app_force_update', 'value' => 0, 'updated_at' => ''],

            ['key' => 'nearest_delivery_date', 'value' => 1, 'updated_at' => ''],

            ['key' => 'rate_us_android', 'value' => '', 'updated_at' => ''],
            ['key' => 'rate_us_ios', 'value' => '', 'updated_at' => ''],

          

        ];

        // Insert data into the app_settings table
        foreach ($settings as $setting) {
            $check = DB::table('app_settings')->where('key',$setting['key'])->first();

            if(!$check){
            DB::table('app_settings')->insert($setting);
            }

        }

        $settingsc = DB::table('app_settings')->get();
        foreach ($settingsc as $row) {
            ContentSetting::set($row->key, $row->value);
        }
        ContentSetting::save();
    }
}
