<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\AllLanguages;

class AllLanguagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */

public function run(){

        $language_codes = array(
            array('id' => '1','code' => 'ab','name' => 'Abkhaz'),
            array('id' => '2','code' => 'aa','name' => 'Afar'),
            array('id' => '3','code' => 'af','name' => 'Afrikaans'),
            array('id' => '4','code' => 'ak','name' => 'Akan'),
            array('id' => '5','code' => 'sq','name' => 'Albanian'),
            array('id' => '6','code' => 'am','name' => 'Amharic'),
            array('id' => '7','code' => 'ar','name' => 'Arabic'),
            array('id' => '8','code' => 'an','name' => 'Aragonese'),
            array('id' => '9','code' => 'hy','name' => 'Armenian'),
            array('id' => '10','code' => 'as','name' => 'Assamese'),
            array('id' => '11','code' => 'av','name' => 'Avaric'),
            array('id' => '12','code' => 'ae','name' => 'Avestan'),
            array('id' => '13','code' => 'ay','name' => 'Aymara'),
            array('id' => '14','code' => 'az','name' => 'Azerbaijani'),
            array('id' => '15','code' => 'bm','name' => 'Bambara'),
            array('id' => '16','code' => 'ba','name' => 'Bashkir'),
            array('id' => '17','code' => 'eu','name' => 'Basque'),
            array('id' => '18','code' => 'be','name' => 'Belarusian'),
            array('id' => '19','code' => 'bn','name' => 'Bengali'),
            array('id' => '20','code' => 'bh','name' => 'Bihari'),
            array('id' => '21','code' => 'bi','name' => 'Bislama'),
            array('id' => '22','code' => 'bs','name' => 'Bosnian'),
            array('id' => '23','code' => 'br','name' => 'Breton'),
            array('id' => '24','code' => 'bg','name' => 'Bulgarian'),
            array('id' => '25','code' => 'my','name' => 'Burmese'),
            array('id' => '26','code' => 'ca','name' => 'Catalan'),
            array('id' => '27','code' => 'ch','name' => 'Chamorro'),
            array('id' => '28','code' => 'ce','name' => 'Chechen'),
            array('id' => '29','code' => 'ny','name' => 'Chichewa'),
            array('id' => '30','code' => 'zh','name' => 'Chinese'),
            array('id' => '31','code' => 'cv','name' => 'Chuvash'),
            array('id' => '32','code' => 'kw','name' => 'Cornish'),
            array('id' => '33','code' => 'co','name' => 'Corsican'),
            array('id' => '34','code' => 'cr','name' => 'Cree'),
            array('id' => '35','code' => 'hr','name' => 'Croatian'),
            array('id' => '36','code' => 'cs','name' => 'Czech'),
            array('id' => '37','code' => 'da','name' => 'Danish'),
            array('id' => '38','code' => 'dv','name' => 'Divehi'),
            array('id' => '39','code' => 'nl','name' => 'Dutch'),
            array('id' => '40','code' => 'en','name' => 'English'),
            array('id' => '41','code' => 'eo','name' => 'Esperanto'),
            array('id' => '42','code' => 'et','name' => 'Estonian'),
            array('id' => '43','code' => 'ee','name' => 'Ewe'),
            array('id' => '44','code' => 'fo','name' => 'Faroese'),
            array('id' => '45','code' => 'fj','name' => 'Fijian'),
            array('id' => '46','code' => 'fi','name' => 'Finnish'),
            array('id' => '47','code' => 'fr','name' => 'French'),
            array('id' => '48','code' => 'ff','name' => 'Fula'),
            array('id' => '49','code' => 'gl','name' => 'Galician'),
            array('id' => '50','code' => 'ka','name' => 'Georgian'),
            array('id' => '51','code' => 'de','name' => 'German'),
            array('id' => '52','code' => 'el','name' => 'Greek'),
            array('id' => '53','code' => 'gn','name' => 'Guaraní'),
            array('id' => '54','code' => 'gu','name' => 'Gujarati'),
            array('id' => '55','code' => 'ht','name' => 'Haitian'),
            array('id' => '56','code' => 'ha','name' => 'Hausa'),
            array('id' => '57','code' => 'he','name' => 'Hebrew (modern)'),
            array('id' => '58','code' => 'hz','name' => 'Herero'),
            array('id' => '59','code' => 'hi','name' => 'Hindi'),
            array('id' => '60','code' => 'ho','name' => 'Hiri Motu'),
            array('id' => '61','code' => 'hu','name' => 'Hungarian'),
            array('id' => '62','code' => 'ia','name' => 'Interlingua'),
            array('id' => '63','code' => 'id','name' => 'Indonesian'),
            array('id' => '64','code' => 'ie','name' => 'Interlingue'),
            array('id' => '65','code' => 'ga','name' => 'Irish'),
            array('id' => '66','code' => 'ig','name' => 'Igbo'),
            array('id' => '67','code' => 'ik','name' => 'Inupiaq'),
            array('id' => '68','code' => 'io','name' => 'Ido'),
            array('id' => '69','code' => 'is','name' => 'Icelandic'),
            array('id' => '70','code' => 'it','name' => 'Italian'),
            array('id' => '71','code' => 'iu','name' => 'Inuktitut'),
            array('id' => '72','code' => 'ja','name' => 'Japanese'),
            array('id' => '73','code' => 'jv','name' => 'Javanese'),
            array('id' => '74','code' => 'kl','name' => 'Kalaallisut'),
            array('id' => '75','code' => 'kn','name' => 'Kannada'),
            array('id' => '76','code' => 'kr','name' => 'Kanuri'),
            array('id' => '77','code' => 'ks','name' => 'Kashmiri'),
            array('id' => '78','code' => 'kk','name' => 'Kazakh'),
            array('id' => '79','code' => 'km','name' => 'Khmer'),
            array('id' => '80','code' => 'ki','name' => 'Kikuyu'),
            array('id' => '81','code' => 'rw','name' => 'Kinyarwanda'),
            array('id' => '82','code' => 'ky','name' => 'Kirghiz'),
            array('id' => '83','code' => 'kv','name' => 'Komi'),
            array('id' => '84','code' => 'kg','name' => 'Kongo'),
            array('id' => '85','code' => 'ko','name' => 'Korean'),
            array('id' => '86','code' => 'ku','name' => 'Kurdish'),
            array('id' => '87','code' => 'kj','name' => 'Kwanyama'),
            array('id' => '88','code' => 'la','name' => 'Latin'),
            array('id' => '89','code' => 'lb','name' => 'Luxembourgish'),
            array('id' => '90','code' => 'lg','name' => 'Luganda'),
            array('id' => '91','code' => 'li','name' => 'Limburgish'),
            array('id' => '92','code' => 'ln','name' => 'Lingala'),
            array('id' => '93','code' => 'lo','name' => 'Lao'),
            array('id' => '94','code' => 'lt','name' => 'Lithuanian'),
            array('id' => '95','code' => 'lu','name' => 'Luba-Katanga'),
            array('id' => '96','code' => 'lv','name' => 'Latvian'),
            array('id' => '97','code' => 'gv','name' => 'Manx'),
            array('id' => '98','code' => 'mk','name' => 'Macedonian'),
            array('id' => '99','code' => 'mg','name' => 'Malagasy'),
            array('id' => '100','code' => 'ms','name' => 'Malay'),
            array('id' => '101','code' => 'ml','name' => 'Malayalam'),
            array('id' => '102','code' => 'mt','name' => 'Maltese'),
            array('id' => '103','code' => 'mi','name' => 'Māori'),
            array('id' => '104','code' => 'mr','name' => 'Marathi (Marāṭhī)'),
            array('id' => '105','code' => 'mh','name' => 'Marshallese'),
            array('id' => '106','code' => 'mn','name' => 'Mongolian'),
            array('id' => '107','code' => 'na','name' => 'Nauru'),
            array('id' => '108','code' => 'nv','name' => 'Navajo'),
            array('id' => '109','code' => 'nb','name' => 'Norwegian Bokmål'),
            array('id' => '110','code' => 'nd','name' => 'North Ndebele'),
            array('id' => '111','code' => 'ne','name' => 'Nepali'),
            array('id' => '112','code' => 'ng','name' => 'Ndonga'),
            array('id' => '113','code' => 'nn','name' => 'Norwegian Nynorsk'),
            array('id' => '114','code' => 'no','name' => 'Norwegian'),
            array('id' => '115','code' => 'ii','name' => 'Nuosu'),
            array('id' => '116','code' => 'nr','name' => 'South Ndebele'),
            array('id' => '117','code' => 'oc','name' => 'Occitan'),
            array('id' => '118','code' => 'oj','name' => 'Ojibwe'),
            array('id' => '119','code' => 'cu','name' => 'Old Church Slavonic'),
            array('id' => '120','code' => 'om','name' => 'Oromo'),
            array('id' => '121','code' => 'or','name' => 'Oriya'),
            array('id' => '122','code' => 'os','name' => 'Ossetian'),
            array('id' => '123','code' => 'pa','name' => 'Panjabi'),
            array('id' => '124','code' => 'pi','name' => 'Pāli'),
            array('id' => '125','code' => 'fa','name' => 'Persian'),
            array('id' => '126','code' => 'pl','name' => 'Polish'),
            array('id' => '127','code' => 'ps','name' => 'Pashto'),
            array('id' => '128','code' => 'pt','name' => 'Portuguese'),
            array('id' => '129','code' => 'qu','name' => 'Quechua'),
            array('id' => '130','code' => 'rm','name' => 'Romansh'),
            array('id' => '131','code' => 'rn','name' => 'Kirundi'),
            array('id' => '132','code' => 'ro','name' => 'Romanian'),
            array('id' => '133','code' => 'ru','name' => 'Russian'),
            array('id' => '134','code' => 'sa','name' => 'Sanskrit (Saṁskṛta)'),
            array('id' => '135','code' => 'sc','name' => 'Sardinian'),
            array('id' => '136','code' => 'sd','name' => 'Sindhi'),
            array('id' => '137','code' => 'se','name' => 'Northern Sami'),
            array('id' => '138','code' => 'sm','name' => 'Samoan'),
            array('id' => '139','code' => 'sg','name' => 'Sango'),
            array('id' => '140','code' => 'sr','name' => 'Serbian'),
            array('id' => '141','code' => 'gd','name' => 'Scottish Gaelic; Gaelic'),
            array('id' => '142','code' => 'sn','name' => 'Shona'),
            array('id' => '143','code' => 'si','name' => 'Sinhala'),
            array('id' => '144','code' => 'sk','name' => 'Slovak'),
            array('id' => '145','code' => 'sl','name' => 'Slovene'),
            array('id' => '146','code' => 'so','name' => 'Somali'),
            array('id' => '147','code' => 'st','name' => 'Southern Sotho'),
            array('id' => '148','code' => 'es','name' => 'Spanish'),
            array('id' => '149','code' => 'su','name' => 'Sundanese'),
            array('id' => '150','code' => 'sw','name' => 'Swahili'),
            array('id' => '151','code' => 'ss','name' => 'Swati'),
            array('id' => '152','code' => 'sv','name' => 'Swedish'),
            array('id' => '153','code' => 'ta','name' => 'Tamil'),
            array('id' => '154','code' => 'te','name' => 'Telugu'),
            array('id' => '155','code' => 'tg','name' => 'Tajik'),
            array('id' => '156','code' => 'th','name' => 'Thai'),
            array('id' => '157','code' => 'ti','name' => 'Tigrinya'),
            array('id' => '158','code' => 'bo','name' => 'Tibetan Standard'),
            array('id' => '159','code' => 'tk','name' => 'Turkmen'),
            array('id' => '160','code' => 'tl','name' => 'Tagalog'),
            array('id' => '161','code' => 'tn','name' => 'Tswana'),
            array('id' => '162','code' => 'to','name' => 'Tonga (Tonga Islands)'),
            array('id' => '163','code' => 'tr','name' => 'Turkish'),
            array('id' => '164','code' => 'ts','name' => 'Tsonga'),
            array('id' => '165','code' => 'tt','name' => 'Tatar'),
            array('id' => '166','code' => 'tw','name' => 'Twi'),
            array('id' => '167','code' => 'ty','name' => 'Tahitian'),
            array('id' => '168','code' => 'ug','name' => 'Uighur'),
            array('id' => '169','code' => 'uk','name' => 'Ukrainian'),
            array('id' => '170','code' => 'ur','name' => 'Urdu'),
            array('id' => '171','code' => 'uz','name' => 'Uzbek'),
            array('id' => '172','code' => 've','name' => 'Venda'),
            array('id' => '173','code' => 'vi','name' => 'Vietnamese'),
            array('id' => '174','code' => 'vo','name' => 'Volapük'),
            array('id' => '175','code' => 'wa','name' => 'Walloon'),
            array('id' => '176','code' => 'cy','name' => 'Welsh'),
            array('id' => '177','code' => 'wo','name' => 'Wolof'),
            array('id' => '178','code' => 'fy','name' => 'Western Frisian'),
            array('id' => '179','code' => 'xh','name' => 'Xhosa'),
            array('id' => '180','code' => 'yi','name' => 'Yiddish'),
            array('id' => '181','code' => 'yo','name' => 'Yoruba'),
            array('id' => '182','code' => 'za','name' => 'Zhuang'),
        );

       foreach ($language_codes as $key => $value) {
            $check = DB::table('all_languages')->where('name', $value['name'])->first();

            if (!$check) {
                AllLanguages::insert([  
                     'name' => $value['name'],
                     'code' => $value['code'],
                     'created_at' => now(),
                ]);
            }  
        }
    }
}
