<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('cities')) {
            Schema::create('cities', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('state_id')->default(0);
                $table->string('city_name')->nullable();
                $table->integer('status')->default(1);
                $table->timestamps();
                // Adding indexes
                $table->index('state_id');
                $table->index('city_name');
                $table->index('created_at');
                $table->index('updated_at');
                
                // Foreign key constraints
                $table->foreign('state_id')->references('id')->on('states')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cities');
    }
};