<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
       if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'phone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('phone', 25)->unique()->nullable();
            });
        }
    }

    public function down()
    {
        if (!\Illuminate\Support\Facades\Schema::hasColumn('users', 'phone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('phone', 25)->unique()->nullable();
            });
        }
    }

};
