<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('user_wallets', 'payment_id')) {
            Schema::table('user_wallets', function (Blueprint $table) {
                $table->unsignedBigInteger('payment_id')->nullable()->after('order_id');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('user_wallets', 'payment_id')) {
            Schema::table('user_wallets', function (Blueprint $table) {
                $table->dropColumn('payment_id');
            });
        }
    }
};
