<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_payments', function (Blueprint $table) {
            if (!Schema::hasColumn('user_payments', 'payment_transection_id')) {
                $table->string('payment_transection_id', 256)
                      ->after('method')
                      ->nullable(false);
            }

            if (!Schema::hasColumn('user_payments', 'payment_transection_data')) {
                $table->longText('payment_transection_data')
                      ->after('payment_transection_id')
                      ->nullable(false);
            }

            if (!Schema::hasColumn('user_payments', 'payment_refferance_id')) {
                $table->string('payment_refferance_id', 256)
                      ->after('payment_transection_data')
                      ->nullable(false);
            }

            if (!Schema::hasColumn('user_payments', 'payment_status')) {
                $table->tinyInteger('payment_status')
                      ->default(0)
                      ->comment('0=processing,1=success,2=failed,3=canceled')
                      ->after('payment_refferance_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_payments', function (Blueprint $table) {
            if (Schema::hasColumn('user_payments', 'payment_transection_id')) {
                $table->dropColumn('payment_transection_id');
            }

            if (Schema::hasColumn('user_payments', 'payment_transection_data')) {
                $table->dropColumn('payment_transection_data');
            }

            if (Schema::hasColumn('user_payments', 'payment_refferance_id')) {
                $table->dropColumn('payment_refferance_id');
            }

            if (Schema::hasColumn('user_payments', 'payment_status')) {
                $table->dropColumn('payment_status');
            }
        });
    }
};
