<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('notifications', 'order_id')) {
            Schema::table('notifications', function (Blueprint $table) {
                $table->unsignedInteger('order_id')->nullable()->after('user_id');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('notifications', 'order_id')) {
            Schema::table('notifications', function (Blueprint $table) {
                $table->dropColumn('order_id');
            });
        }
    }
};
