<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('user_card_details')) {
            Schema::create('user_card_details', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id')->index();
                $table->enum('card_type', ['VISA', 'MASTER', 'MADA'])->default('VISA');
                $table->string('card_no')->nullable();
                $table->string('card_holder_name')->nullable();
                $table->string('month', 2)->nullable();
                $table->integer('year')->nullable();
                $table->integer('cvv')->nullable();
                $table->integer('set_as_default')->default(1);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_card_details');
    }
};
