<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (!Schema::hasTable('user_auth_logins')) {
            Schema::create('user_auth_logins', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id')->nullable();
                $table->text('api_token')->nullable();
                $table->text('player_id')->nullable();
                $table->text('fcm_token')->nullable();
                $table->text('device_token')->nullable();
                $table->enum('device_type', ['android', 'ios', 'web'])->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_auth_logins');
    }
};
